/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.serialize.kryo;

import org.gradle.messaging.serialize.Decoder;
import org.gradle.messaging.serialize.Encoder;
import org.gradle.messaging.serialize.ObjectReader;
import org.gradle.messaging.serialize.ObjectWriter;
import org.gradle.messaging.serialize.kryo.StatefulSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeSafeSerializer<T>
implements StatefulSerializer<Object> {
    private final Class<T> type;
    private final StatefulSerializer<T> serializer;

    public TypeSafeSerializer(Class<T> type, StatefulSerializer<T> serializer) {
        this.type = type;
        this.serializer = serializer;
    }

    @Override
    public ObjectReader<Object> newReader(Decoder decoder) {
        final ObjectReader<T> reader = this.serializer.newReader(decoder);
        return new ObjectReader<Object>(){

            @Override
            public Object read() throws Exception {
                return reader.read();
            }
        };
    }

    @Override
    public ObjectWriter<Object> newWriter(Encoder encoder) {
        final ObjectWriter<T> writer = this.serializer.newWriter(encoder);
        return new ObjectWriter<Object>(){

            @Override
            public void write(Object value) throws Exception {
                writer.write(TypeSafeSerializer.this.type.cast(value));
            }
        };
    }
}

