/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal.inet;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.internal.UncheckedException;
import org.gradle.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InetAddressFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(InetAddressFactory.class);
    private final Object lock = new Object();
    private List<InetAddress> localAddresses;
    private List<InetAddress> remoteAddresses;
    private List<NetworkInterface> multicastInterfaces;

    public String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return this.findRemoteAddresses().get(0).toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocal(InetAddress address) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.init();
                return this.localAddresses.contains(address);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not determine the IP addresses for this machine.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InetAddress> findLocalAddresses() {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.init();
                if (!this.localAddresses.isEmpty()) {
                    return this.localAddresses;
                }
                InetAddress fallback = InetAddress.getByName(null);
                LOGGER.debug("No loopback addresses, using fallback {}", (Object)fallback);
                return Collections.singletonList(fallback);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not determine the local IP addresses for this machine.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InetAddress> findRemoteAddresses() {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.init();
                if (!this.remoteAddresses.isEmpty()) {
                    return this.remoteAddresses;
                }
                InetAddress fallback = InetAddress.getLocalHost();
                LOGGER.debug("No remote addresses, using fallback {}", (Object)fallback);
                return Collections.singletonList(fallback);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not determine the remote IP addresses for this machine.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NetworkInterface> findMulticastInterfaces() {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.init();
                if (this.multicastInterfaces.isEmpty()) {
                    LOGGER.debug("No multicast interfaces, using fallback");
                    return CollectionUtils.toList(NetworkInterface.getNetworkInterfaces());
                }
                return this.multicastInterfaces;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not determine the multicast network interfaces for this machine.", e);
        }
    }

    private void init() throws Exception {
        if (this.localAddresses != null) {
            return;
        }
        Transformer<Boolean, NetworkInterface> loopback = this.loopback();
        Transformer<Boolean, NetworkInterface> multicast = this.multicast();
        this.localAddresses = new ArrayList<InetAddress>();
        this.remoteAddresses = new ArrayList<InetAddress>();
        this.multicastInterfaces = new ArrayList<NetworkInterface>();
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface networkInterface = interfaces.nextElement();
            LOGGER.debug("Adding IP addresses for network interface {}", (Object)networkInterface.getDisplayName());
            try {
                Boolean isLoopbackInterface = (Boolean)loopback.transform((Object)networkInterface);
                LOGGER.debug("Is this a loopback interface? {}", (Object)isLoopbackInterface);
                Boolean isMulticast = (Boolean)multicast.transform((Object)networkInterface);
                LOGGER.debug("Is this a multicast interface? {}", (Object)isMulticast);
                boolean isRemote = false;
                Enumeration<InetAddress> candidates = networkInterface.getInetAddresses();
                while (candidates.hasMoreElements()) {
                    InetAddress candidate = candidates.nextElement();
                    if (isLoopbackInterface == null) {
                        if (candidate.isLoopbackAddress()) {
                            LOGGER.debug("Adding loopback address {}", (Object)candidate);
                            this.localAddresses.add(candidate);
                            continue;
                        }
                        LOGGER.debug("Adding remote address {}", (Object)candidate);
                        this.remoteAddresses.add(candidate);
                        isRemote = true;
                        continue;
                    }
                    if (isLoopbackInterface.booleanValue()) {
                        if (candidate.isLoopbackAddress()) {
                            LOGGER.debug("Adding loopback address {}", (Object)candidate);
                            this.localAddresses.add(candidate);
                            continue;
                        }
                        LOGGER.debug("Ignoring remote address on loopback interface {}", (Object)candidate);
                        continue;
                    }
                    if (candidate.isLoopbackAddress()) {
                        LOGGER.debug("Ignoring loopback address on remote interface {}", (Object)candidate);
                        continue;
                    }
                    LOGGER.debug("Adding remote address {}", (Object)candidate);
                    this.remoteAddresses.add(candidate);
                    isRemote = true;
                }
                if (Boolean.FALSE.equals(isMulticast)) continue;
                if (isRemote) {
                    LOGGER.debug("Adding remote multicast interface {}", (Object)networkInterface.getDisplayName());
                    this.multicastInterfaces.add(0, networkInterface);
                    continue;
                }
                LOGGER.debug("Adding loopback multicast interface {}", (Object)networkInterface.getDisplayName());
                this.multicastInterfaces.add(networkInterface);
            }
            catch (Throwable e) {
                throw new RuntimeException(String.format("Could not determine the IP addresses for network interface %s", networkInterface.getName()), e);
            }
        }
    }

    private Transformer<Boolean, NetworkInterface> loopback() {
        try {
            Method method = NetworkInterface.class.getMethod("isLoopback", new Class[0]);
            return new MethodBackedTransformer(method);
        }
        catch (NoSuchMethodException e) {
            return new Unknown();
        }
    }

    private Transformer<Boolean, NetworkInterface> multicast() {
        try {
            Method method = NetworkInterface.class.getMethod("supportsMulticast", new Class[0]);
            return new MethodBackedTransformer(method);
        }
        catch (NoSuchMethodException e) {
            return new Unknown();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodBackedTransformer
    implements Transformer<Boolean, NetworkInterface> {
        private final Method method;

        public MethodBackedTransformer(Method method) {
            this.method = method;
        }

        public Boolean transform(NetworkInterface original) {
            try {
                try {
                    return (Boolean)this.method.invoke((Object)original, new Object[0]);
                }
                catch (InvocationTargetException e) {
                    if (!(e.getCause() instanceof SocketException)) {
                        throw e.getCause();
                    }
                    return null;
                }
            }
            catch (Throwable throwable) {
                throw UncheckedException.throwAsUncheckedException((Throwable)throwable);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Unknown
    implements Transformer<Boolean, NetworkInterface> {
        private Unknown() {
        }

        public Boolean transform(NetworkInterface original) {
            return null;
        }
    }
}

