/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal.hub;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.gradle.messaging.remote.Address;
import org.gradle.messaging.remote.internal.MessageSerializer;
import org.gradle.messaging.remote.internal.hub.protocol.ChannelIdentifier;
import org.gradle.messaging.remote.internal.hub.protocol.ChannelMessage;
import org.gradle.messaging.remote.internal.hub.protocol.EndOfStream;
import org.gradle.messaging.remote.internal.hub.protocol.InterHubMessage;
import org.gradle.messaging.serialize.Decoder;
import org.gradle.messaging.serialize.FlushableEncoder;
import org.gradle.messaging.serialize.ObjectReader;
import org.gradle.messaging.serialize.ObjectWriter;
import org.gradle.messaging.serialize.kryo.KryoBackedDecoder;
import org.gradle.messaging.serialize.kryo.KryoBackedEncoder;
import org.gradle.messaging.serialize.kryo.StatefulSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterHubMessageSerializer
implements MessageSerializer<InterHubMessage> {
    private static final byte CHANNEL_MESSAGE = 1;
    private static final byte END_STREAM_MESSAGE = 2;
    private final StatefulSerializer<Object> payloadSerializer;

    public InterHubMessageSerializer(StatefulSerializer<Object> payloadSerializer) {
        this.payloadSerializer = payloadSerializer;
    }

    @Override
    public ObjectReader<InterHubMessage> newReader(InputStream inputStream, Address localAddress, Address remoteAddress) {
        KryoBackedDecoder decoder = new KryoBackedDecoder(inputStream);
        return new MessageReader(decoder, this.payloadSerializer.newReader(decoder));
    }

    @Override
    public ObjectWriter<InterHubMessage> newWriter(OutputStream outputStream) {
        KryoBackedEncoder encoder = new KryoBackedEncoder(outputStream);
        return new MessageWriter(encoder, this.payloadSerializer.newWriter(encoder));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MessageWriter
    implements ObjectWriter<InterHubMessage> {
        private final Map<ChannelIdentifier, Integer> channels = new HashMap<ChannelIdentifier, Integer>();
        private final FlushableEncoder encoder;
        private final ObjectWriter<Object> payloadWriter;

        public MessageWriter(FlushableEncoder encoder, ObjectWriter<Object> payloadWriter) {
            this.encoder = encoder;
            this.payloadWriter = payloadWriter;
        }

        @Override
        public void write(InterHubMessage message) throws Exception {
            if (message instanceof ChannelMessage) {
                ChannelMessage channelMessage = (ChannelMessage)message;
                this.encoder.writeByte((byte)1);
                this.writeChannelId(channelMessage);
                this.payloadWriter.write(channelMessage.getPayload());
            } else if (message instanceof EndOfStream) {
                this.encoder.writeByte((byte)2);
            } else {
                throw new IllegalArgumentException();
            }
            this.encoder.flush();
        }

        private void writeChannelId(ChannelMessage channelMessage) throws IOException {
            Integer channelNum = this.channels.get(channelMessage.getChannel());
            if (channelNum == null) {
                channelNum = this.channels.size();
                this.channels.put(channelMessage.getChannel(), channelNum);
                this.encoder.writeSmallInt(channelNum);
                this.encoder.writeString(channelMessage.getChannel().getName());
            } else {
                this.encoder.writeSmallInt(channelNum);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MessageReader
    implements ObjectReader<InterHubMessage> {
        private final Map<Integer, ChannelIdentifier> channels = new HashMap<Integer, ChannelIdentifier>();
        private final Decoder decoder;
        private final ObjectReader<?> payloadReader;

        public MessageReader(Decoder decoder, ObjectReader<?> payloadReader) {
            this.decoder = decoder;
            this.payloadReader = payloadReader;
        }

        @Override
        public InterHubMessage read() throws Exception {
            switch (this.decoder.readByte()) {
                case 1: {
                    ChannelIdentifier channelId = this.readChannelId();
                    Object payload = this.payloadReader.read();
                    return new ChannelMessage(channelId, payload);
                }
                case 2: {
                    return new EndOfStream();
                }
            }
            throw new IllegalArgumentException();
        }

        private ChannelIdentifier readChannelId() throws IOException {
            int channelNum = this.decoder.readSmallInt();
            ChannelIdentifier channelId = this.channels.get(channelNum);
            if (channelId == null) {
                String channel = this.decoder.readString();
                channelId = new ChannelIdentifier(channel);
                this.channels.put(channelNum, channelId);
            }
            return channelId;
        }
    }
}

