/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.mvn3.org.sonatype.aether.collection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.mvn3.org.sonatype.aether.RequestTrace;
import org.gradle.mvn3.org.sonatype.aether.graph.Dependency;
import org.gradle.mvn3.org.sonatype.aether.repository.RemoteRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectRequest {
    private Dependency root;
    private List<Dependency> dependencies = Collections.emptyList();
    private List<Dependency> managedDependencies = Collections.emptyList();
    private List<RemoteRepository> repositories = Collections.emptyList();
    private String context = "";
    private RequestTrace trace;

    public CollectRequest() {
    }

    public CollectRequest(Dependency root, List<RemoteRepository> repositories) {
        this.setRoot(root);
        this.setRepositories(repositories);
    }

    public CollectRequest(Dependency root, List<Dependency> dependencies, List<RemoteRepository> repositories) {
        this.setRoot(root);
        this.setDependencies(dependencies);
        this.setRepositories(repositories);
    }

    public CollectRequest(List<Dependency> dependencies, List<Dependency> managedDependencies, List<RemoteRepository> repositories) {
        this.setDependencies(dependencies);
        this.setManagedDependencies(managedDependencies);
        this.setRepositories(repositories);
    }

    public Dependency getRoot() {
        return this.root;
    }

    public CollectRequest setRoot(Dependency root) {
        this.root = root;
        return this;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public CollectRequest setDependencies(List<Dependency> dependencies) {
        this.dependencies = dependencies == null ? Collections.emptyList() : dependencies;
        return this;
    }

    public CollectRequest addDependency(Dependency dependency) {
        if (dependency != null) {
            if (this.dependencies.isEmpty()) {
                this.dependencies = new ArrayList<Dependency>();
            }
            this.dependencies.add(dependency);
        }
        return this;
    }

    public List<Dependency> getManagedDependencies() {
        return this.managedDependencies;
    }

    public CollectRequest setManagedDependencies(List<Dependency> managedDependencies) {
        this.managedDependencies = managedDependencies == null ? Collections.emptyList() : managedDependencies;
        return this;
    }

    public CollectRequest addManagedDependency(Dependency managedDependency) {
        if (managedDependency != null) {
            if (this.managedDependencies.isEmpty()) {
                this.managedDependencies = new ArrayList<Dependency>();
            }
            this.managedDependencies.add(managedDependency);
        }
        return this;
    }

    public List<RemoteRepository> getRepositories() {
        return this.repositories;
    }

    public CollectRequest setRepositories(List<RemoteRepository> repositories) {
        this.repositories = repositories == null ? Collections.emptyList() : repositories;
        return this;
    }

    public CollectRequest addRepository(RemoteRepository repository) {
        if (repository != null) {
            if (this.repositories.isEmpty()) {
                this.repositories = new ArrayList<RemoteRepository>();
            }
            this.repositories.add(repository);
        }
        return this;
    }

    public String getRequestContext() {
        return this.context;
    }

    public CollectRequest setRequestContext(String context) {
        this.context = context != null ? context : "";
        return this;
    }

    public RequestTrace getTrace() {
        return this.trace;
    }

    public CollectRequest setTrace(RequestTrace trace) {
        this.trace = trace;
        return this;
    }

    public String toString() {
        return this.getRoot() + " -> " + this.getDependencies() + " < " + this.getRepositories();
    }
}

