/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.buildcomparison.outcome.internal.archive.entry;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.gradle.api.Transformer;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.plugins.buildcomparison.outcome.internal.archive.entry.ArchiveEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileToArchiveEntrySetTransformer
implements Transformer<Set<ArchiveEntry>, File> {
    private final Transformer<ArchiveEntry, ZipEntry> entryTransformer;

    public FileToArchiveEntrySetTransformer(Transformer<ArchiveEntry, ZipEntry> entryTransformer) {
        this.entryTransformer = entryTransformer;
    }

    public Set<ArchiveEntry> transform(File archiveFile) {
        FileInputStream fileInputStream;
        HashSet<ArchiveEntry> entries = new HashSet<ArchiveEntry>();
        try {
            fileInputStream = new FileInputStream(archiveFile);
        }
        catch (FileNotFoundException e) {
            throw new UncheckedIOException((Throwable)e);
        }
        ZipInputStream zipStream = new ZipInputStream(fileInputStream);
        try {
            ZipEntry entry = zipStream.getNextEntry();
            while (entry != null) {
                entries.add((ArchiveEntry)this.entryTransformer.transform((Object)entry));
                zipStream.closeEntry();
                entry = zipStream.getNextEntry();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)zipStream);
        }
        return entries;
    }
}

