/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.buildcomparison.gradle.internal;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Transformer;
import org.gradle.api.plugins.buildcomparison.outcome.internal.BuildOutcome;
import org.gradle.api.plugins.buildcomparison.outcome.internal.FileOutcomeIdentifier;
import org.gradle.api.plugins.buildcomparison.outcome.internal.archive.GeneratedArchiveBuildOutcome;
import org.gradle.api.plugins.buildcomparison.outcome.internal.unknown.UnknownBuildOutcome;
import org.gradle.internal.resource.local.FileStore;
import org.gradle.internal.resource.local.LocallyAvailableResource;
import org.gradle.tooling.model.internal.outcomes.GradleBuildOutcome;
import org.gradle.tooling.model.internal.outcomes.GradleFileBuildOutcome;
import org.gradle.tooling.model.internal.outcomes.ProjectOutcomes;
import org.gradle.util.GFileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GradleBuildOutcomeSetTransformer
implements Transformer<Set<BuildOutcome>, ProjectOutcomes> {
    private final FileStore<String> fileStore;
    private final String fileStorePrefix;
    private final List<String> zipArchiveTypes = Arrays.asList(FileOutcomeIdentifier.JAR_ARTIFACT.getTypeIdentifier(), FileOutcomeIdentifier.EAR_ARTIFACT.getTypeIdentifier(), FileOutcomeIdentifier.WAR_ARTIFACT.getTypeIdentifier(), FileOutcomeIdentifier.ZIP_ARTIFACT.getTypeIdentifier());

    public GradleBuildOutcomeSetTransformer(FileStore<String> fileStore, String fileStorePrefix) {
        this.fileStore = fileStore;
        this.fileStorePrefix = fileStorePrefix;
    }

    public Set<BuildOutcome> transform(ProjectOutcomes rootProject) {
        HashSet<BuildOutcome> keyedOutcomes = new HashSet<BuildOutcome>();
        this.addBuildOutcomes(rootProject, rootProject, keyedOutcomes);
        return keyedOutcomes;
    }

    private void addBuildOutcomes(ProjectOutcomes projectOutcomes, ProjectOutcomes rootProject, Set<BuildOutcome> buildOutcomes) {
        for (GradleBuildOutcome outcome : projectOutcomes.getOutcomes()) {
            if (outcome instanceof GradleFileBuildOutcome) {
                this.addFileBuildOutcome((GradleFileBuildOutcome)outcome, rootProject, buildOutcomes);
                continue;
            }
            new UnknownBuildOutcome(outcome.getTaskPath(), outcome.getDescription());
        }
        for (ProjectOutcomes childProject : projectOutcomes.getChildren()) {
            this.addBuildOutcomes(childProject, rootProject, buildOutcomes);
        }
    }

    private void addFileBuildOutcome(GradleFileBuildOutcome outcome, ProjectOutcomes rootProject, Set<BuildOutcome> translatedOutcomes) {
        if (this.zipArchiveTypes.contains(outcome.getTypeIdentifier())) {
            File originalFile = outcome.getFile();
            String relativePath = GFileUtils.relativePath((File)rootProject.getProjectDirectory(), (File)originalFile);
            LocallyAvailableResource resource = null;
            if (originalFile.exists()) {
                String filestoreDestination = String.format("%s/%s/%s", this.fileStorePrefix, outcome.getTaskPath(), originalFile.getName());
                resource = this.fileStore.move((Object)filestoreDestination, originalFile);
            }
            GeneratedArchiveBuildOutcome buildOutcome = new GeneratedArchiveBuildOutcome(outcome.getTaskPath(), outcome.getDescription(), resource, relativePath);
            translatedOutcomes.add(buildOutcome);
        } else {
            translatedOutcomes.add(new UnknownBuildOutcome(outcome.getTaskPath(), outcome.getDescription()));
        }
    }
}

