/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.plugins;

import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.internal.Factory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.language.base.internal.DefaultProjectSourceSet;
import org.gradle.model.ModelRule;
import org.gradle.model.ModelRules;
import org.gradle.runtime.base.BinaryContainer;
import org.gradle.runtime.base.ProjectBinary;
import org.gradle.runtime.base.internal.BinaryInternal;
import org.gradle.runtime.base.internal.DefaultBinaryContainer;
import org.gradle.runtime.base.internal.DefaultProjectComponentContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class LanguageBasePlugin
implements Plugin<Project> {
    private final Instantiator instantiator;
    private final ModelRules modelRules;

    @Inject
    public LanguageBasePlugin(Instantiator instantiator, ModelRules modelRules) {
        this.instantiator = instantiator;
        this.modelRules = modelRules;
    }

    public void apply(final Project target) {
        target.getExtensions().create("softwareComponents", DefaultProjectComponentContainer.class, new Object[]{this.instantiator});
        target.getExtensions().create("sources", DefaultProjectSourceSet.class, new Object[]{this.instantiator});
        final BinaryContainer binaries = (BinaryContainer)target.getExtensions().create("binaries", DefaultBinaryContainer.class, new Object[]{this.instantiator});
        this.modelRules.register("binaries", BinaryContainer.class, (Factory)new Factory<BinaryContainer>(){

            public BinaryContainer create() {
                return binaries;
            }
        });
        this.modelRules.rule((ModelRule)new AttachBinariesToLifecycle());
        binaries.withType(BinaryInternal.class).all((Action)new Action<BinaryInternal>(){

            public void execute(BinaryInternal binary) {
                Task binaryLifecycleTask = target.task(binary.getNamingScheme().getLifecycleTaskName());
                binaryLifecycleTask.setGroup("build");
                binaryLifecycleTask.setDescription(String.format("Assembles %s.", binary));
                binary.setBuildTask(binaryLifecycleTask);
            }
        });
    }

    private static class AttachBinariesToLifecycle
    extends ModelRule {
        private AttachBinariesToLifecycle() {
        }

        void attach(TaskContainer tasks, BinaryContainer binaries) {
            Task assembleTask = tasks.getByName("assemble");
            for (ProjectBinary binary : binaries.withType(ProjectBinary.class)) {
                if (!binary.isBuildable()) continue;
                assembleTask.dependsOn(new Object[]{binary});
            }
        }
    }
}

