/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.internal.plugins;

import org.apache.commons.lang.StringUtils;
import org.gradle.api.Rule;
import org.gradle.api.Task;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.TaskContainer;

public class CleanRule
implements Rule {
    public static final String PREFIX = "clean";
    private final TaskContainer tasks;

    public CleanRule(TaskContainer tasks) {
        this.tasks = tasks;
    }

    public String getDescription() {
        return String.format("Pattern: %s<TaskName>: Cleans the output files of a task.", PREFIX);
    }

    public String toString() {
        return String.format("Rule: %s", this.getDescription());
    }

    public void apply(String taskName) {
        if (!taskName.startsWith(PREFIX)) {
            return;
        }
        String targetTaskName = taskName.substring(PREFIX.length());
        if (Character.isLowerCase(targetTaskName.charAt(0))) {
            return;
        }
        Task task = (Task)this.tasks.findByName(StringUtils.uncapitalize((String)targetTaskName));
        if (task == null) {
            return;
        }
        Delete clean = (Delete)this.tasks.create(taskName, Delete.class);
        clean.delete(new Object[]{task.getOutputs().getFiles()});
    }
}

