/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.mvn3.org.apache.maven.wagon.shared.http4;

import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.gradle.mvn3.org.apache.maven.wagon.shared.http4.AbstractHttpClientWagon;

public class RelaxedX509TrustManager
implements X509TrustManager {
    private X509TrustManager standardTrustManager = null;

    protected static SSLContext createRelaxedSSLContext() throws IOException {
        try {
            SSLContext context = SSLContext.getInstance("SSL");
            context.init(null, new TrustManager[]{new RelaxedX509TrustManager(null)}, null);
            return context;
        }
        catch (Exception e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    public RelaxedX509TrustManager(KeyStore keystore) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory.init(keystore);
        TrustManager[] trustmanagers = factory.getTrustManagers();
        if (trustmanagers.length == 0) {
            throw new NoSuchAlgorithmException("no trust manager found");
        }
        this.standardTrustManager = (X509TrustManager)trustmanagers[0];
    }

    public void checkClientTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        this.standardTrustManager.checkClientTrusted(certificates, authType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkServerTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        if (certificates != null && certificates.length == 1) {
            try {
                certificates[0].checkValidity();
                return;
            }
            catch (CertificateExpiredException e) {
                if (AbstractHttpClientWagon.IGNORE_SSL_VALIDITY_DATES) return;
                throw e;
            }
            catch (CertificateNotYetValidException e) {
                if (AbstractHttpClientWagon.IGNORE_SSL_VALIDITY_DATES) return;
                throw e;
            }
        } else {
            this.standardTrustManager.checkServerTrusted(certificates, authType);
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.standardTrustManager.getAcceptedIssuers();
    }
}

