/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.ivy.tasks;

import java.io.File;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.publish.ivy.IvyArtifact;
import org.gradle.api.publish.ivy.IvyConfiguration;
import org.gradle.api.publish.ivy.IvyModuleDescriptor;
import org.gradle.api.publish.ivy.internal.dependency.IvyDependencyInternal;
import org.gradle.api.publish.ivy.internal.publication.IvyModuleDescriptorInternal;
import org.gradle.api.publish.ivy.internal.publisher.IvyDescriptorFileGenerator;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

@Incubating
public class GenerateIvyDescriptor
extends DefaultTask {
    private IvyModuleDescriptor descriptor;
    private Object destination;

    public GenerateIvyDescriptor() {
        this.getOutputs().upToDateWhen(Specs.satisfyNone());
    }

    @Inject
    protected FileResolver getFileResolver() {
        throw new UnsupportedOperationException();
    }

    public IvyModuleDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(IvyModuleDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    @OutputFile
    public File getDestination() {
        return this.destination == null ? null : this.getFileResolver().resolve(this.destination);
    }

    public void setDestination(Object destination) {
        this.destination = destination;
    }

    @TaskAction
    public void doGenerate() {
        IvyModuleDescriptorInternal descriptorInternal = GenerateIvyDescriptor.toIvyModuleDescriptorInternal(this.getDescriptor());
        IvyDescriptorFileGenerator ivyGenerator = new IvyDescriptorFileGenerator(descriptorInternal.getProjectIdentity());
        ivyGenerator.setStatus(descriptorInternal.getStatus());
        for (IvyConfiguration ivyConfiguration : descriptorInternal.getConfigurations()) {
            ivyGenerator.addConfiguration(ivyConfiguration);
        }
        for (IvyArtifact ivyArtifact : descriptorInternal.getArtifacts()) {
            ivyGenerator.addArtifact(ivyArtifact);
        }
        for (IvyDependencyInternal ivyDependency : descriptorInternal.getDependencies()) {
            ivyGenerator.addDependency(ivyDependency);
        }
        ivyGenerator.withXml(descriptorInternal.getXmlAction()).writeTo(this.getDestination());
    }

    private static IvyModuleDescriptorInternal toIvyModuleDescriptorInternal(IvyModuleDescriptor ivyModuleDescriptor) {
        if (ivyModuleDescriptor == null) {
            return null;
        }
        if (ivyModuleDescriptor instanceof IvyModuleDescriptorInternal) {
            return (IvyModuleDescriptorInternal)ivyModuleDescriptor;
        }
        throw new InvalidUserDataException(String.format("ivyModuleDescriptor implementations must implement the '%s' interface, implementation '%s' does not", IvyModuleDescriptorInternal.class.getName(), ivyModuleDescriptor.getClass().getName()));
    }
}

