/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.ivy.plugins;

import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.internal.artifacts.ModuleInternal;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.internal.ProjectDependencyPublicationResolver;
import org.gradle.api.publish.ivy.IvyArtifact;
import org.gradle.api.publish.ivy.IvyPublication;
import org.gradle.api.publish.ivy.internal.IvyPublicationTasksModelRule;
import org.gradle.api.publish.ivy.internal.artifact.IvyArtifactNotationParserFactory;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyPublication;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyPublicationIdentity;
import org.gradle.api.publish.plugins.PublishingPlugin;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.model.ModelRule;
import org.gradle.model.ModelRules;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class IvyPublishPlugin
implements Plugin<Project> {
    private final Instantiator instantiator;
    private final DependencyMetaDataProvider dependencyMetaDataProvider;
    private final FileResolver fileResolver;
    private final ModelRules modelRules;
    private final ProjectDependencyPublicationResolver projectDependencyResolver;

    @Inject
    public IvyPublishPlugin(Instantiator instantiator, DependencyMetaDataProvider dependencyMetaDataProvider, FileResolver fileResolver, ModelRules modelRules, ProjectDependencyPublicationResolver projectDependencyResolver) {
        this.instantiator = instantiator;
        this.dependencyMetaDataProvider = dependencyMetaDataProvider;
        this.fileResolver = fileResolver;
        this.modelRules = modelRules;
        this.projectDependencyResolver = projectDependencyResolver;
    }

    public void apply(Project project) {
        project.getPlugins().apply(PublishingPlugin.class);
        project.getExtensions().configure(PublishingExtension.class, (Action)new Action<PublishingExtension>(){

            public void execute(PublishingExtension extension) {
                extension.getPublications().registerFactory(IvyPublication.class, (NamedDomainObjectFactory)new IvyPublicationFactory(IvyPublishPlugin.this.dependencyMetaDataProvider, IvyPublishPlugin.this.instantiator, IvyPublishPlugin.this.fileResolver));
            }
        });
        this.modelRules.rule((ModelRule)new IvyPublicationTasksModelRule(project));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IvyPublicationFactory
    implements NamedDomainObjectFactory<IvyPublication> {
        private final Instantiator instantiator;
        private final DependencyMetaDataProvider dependencyMetaDataProvider;
        private final FileResolver fileResolver;

        private IvyPublicationFactory(DependencyMetaDataProvider dependencyMetaDataProvider, Instantiator instantiator, FileResolver fileResolver) {
            this.dependencyMetaDataProvider = dependencyMetaDataProvider;
            this.instantiator = instantiator;
            this.fileResolver = fileResolver;
        }

        public IvyPublication create(String name) {
            ModuleInternal module = this.dependencyMetaDataProvider.getModule();
            DefaultIvyPublicationIdentity publicationIdentity = new DefaultIvyPublicationIdentity(module.getGroup(), module.getName(), module.getVersion());
            NotationParser<Object, IvyArtifact> notationParser = new IvyArtifactNotationParserFactory(this.instantiator, this.fileResolver, publicationIdentity).create();
            return (IvyPublication)this.instantiator.newInstance(DefaultIvyPublication.class, new Object[]{name, this.instantiator, publicationIdentity, notationParser, IvyPublishPlugin.this.projectDependencyResolver});
        }
    }
}

