/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.ivy.internal.publisher;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.XmlProvider;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.internal.xml.SimpleXmlWriter;
import org.gradle.api.internal.xml.XmlTransformer;
import org.gradle.api.publish.ivy.IvyArtifact;
import org.gradle.api.publish.ivy.IvyConfiguration;
import org.gradle.api.publish.ivy.internal.dependency.IvyDependencyInternal;
import org.gradle.api.publish.ivy.internal.publisher.IvyPublicationIdentity;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IvyDescriptorFileGenerator {
    private static final String IVY_FILE_ENCODING = "UTF-8";
    private static final String IVY_DATE_PATTERN = "yyyyMMddHHmmss";
    private final SimpleDateFormat ivyDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    private final IvyPublicationIdentity projectIdentity;
    private String status;
    private XmlTransformer xmlTransformer = new XmlTransformer();
    private List<IvyConfiguration> configurations = new ArrayList<IvyConfiguration>();
    private List<IvyArtifact> artifacts = new ArrayList<IvyArtifact>();
    private List<IvyDependencyInternal> dependencies = new ArrayList<IvyDependencyInternal>();

    public IvyDescriptorFileGenerator(IvyPublicationIdentity projectIdentity) {
        this.projectIdentity = projectIdentity;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public IvyDescriptorFileGenerator addConfiguration(IvyConfiguration ivyConfiguration) {
        this.configurations.add(ivyConfiguration);
        return this;
    }

    public IvyDescriptorFileGenerator addArtifact(IvyArtifact ivyArtifact) {
        this.artifacts.add(ivyArtifact);
        return this;
    }

    public IvyDescriptorFileGenerator addDependency(IvyDependencyInternal ivyDependency) {
        this.dependencies.add(ivyDependency);
        return this;
    }

    public IvyDescriptorFileGenerator withXml(Action<XmlProvider> action) {
        this.xmlTransformer.addAction(action);
        return this;
    }

    public IvyDescriptorFileGenerator writeTo(File file) {
        this.xmlTransformer.transform(file, IVY_FILE_ENCODING, (Action)new Action<Writer>(){

            public void execute(Writer writer) {
                try {
                    IvyDescriptorFileGenerator.this.writeDescriptor(writer);
                }
                catch (IOException e) {
                    throw new UncheckedIOException((Throwable)e);
                }
            }
        });
        return this;
    }

    private void writeDescriptor(Writer writer) throws IOException {
        OptionalAttributeXmlWriter xmlWriter = new OptionalAttributeXmlWriter(writer, "  ", IVY_FILE_ENCODING);
        xmlWriter.startElement("ivy-module").attribute("version", "2.0");
        if (this.usesClassifier()) {
            xmlWriter.attribute("xmlns:m", "http://ant.apache.org/ivy/maven");
        }
        xmlWriter.startElement("info").attribute("organisation", this.projectIdentity.getOrganisation()).attribute("module", this.projectIdentity.getModule()).attribute("revision", this.projectIdentity.getRevision()).attribute("status", this.status).attribute("publication", this.ivyDateFormat.format(new Date())).endElement();
        this.writeConfigurations(xmlWriter);
        this.writePublications(xmlWriter);
        this.writeDependencies(xmlWriter);
        xmlWriter.endElement();
    }

    private boolean usesClassifier() {
        for (IvyArtifact artifact : this.artifacts) {
            if (artifact.getClassifier() == null) continue;
            return true;
        }
        for (IvyDependencyInternal dependency : this.dependencies) {
            for (DependencyArtifact dependencyArtifact : dependency.getArtifacts()) {
                if (dependencyArtifact.getClassifier() == null) continue;
                return true;
            }
        }
        return false;
    }

    private void writeConfigurations(OptionalAttributeXmlWriter xmlWriter) throws IOException {
        xmlWriter.startElement("configurations");
        for (IvyConfiguration configuration : this.configurations) {
            xmlWriter.startElement("conf").attribute("name", configuration.getName()).attribute("visibility", "public");
            if (configuration.getExtends().size() > 0) {
                xmlWriter.attribute("extends", CollectionUtils.join((String)",", configuration.getExtends()));
            }
            xmlWriter.endElement();
        }
        xmlWriter.endElement();
    }

    private void writePublications(OptionalAttributeXmlWriter xmlWriter) throws IOException {
        xmlWriter.startElement("publications");
        for (IvyArtifact artifact : this.artifacts) {
            xmlWriter.startElement("artifact").attribute("name", artifact.getName()).attribute("type", artifact.getType()).attribute("ext", artifact.getExtension()).attribute("conf", artifact.getConf()).attribute("m:classifier", artifact.getClassifier()).endElement();
        }
        xmlWriter.endElement();
    }

    private void writeDependencies(OptionalAttributeXmlWriter xmlWriter) throws IOException {
        xmlWriter.startElement("dependencies");
        for (IvyDependencyInternal dependency : this.dependencies) {
            xmlWriter.startElement("dependency").attribute("org", dependency.getOrganisation()).attribute("name", dependency.getModule()).attribute("rev", dependency.getRevision()).attribute("conf", dependency.getConfMapping());
            for (DependencyArtifact dependencyArtifact : dependency.getArtifacts()) {
                this.printDependencyArtifact(dependencyArtifact, xmlWriter);
            }
            xmlWriter.endElement();
        }
        xmlWriter.endElement();
    }

    private void printDependencyArtifact(DependencyArtifact dependencyArtifact, OptionalAttributeXmlWriter xmlWriter) throws IOException {
        xmlWriter.startElement("artifact").attribute("name", dependencyArtifact.getName()).attribute("type", dependencyArtifact.getType()).attribute("ext", dependencyArtifact.getExtension()).attribute("m:classifier", dependencyArtifact.getClassifier()).endElement();
    }

    private static class OptionalAttributeXmlWriter
    extends SimpleXmlWriter {
        public OptionalAttributeXmlWriter(Writer writer, String indent, String encoding) throws IOException {
            super(writer, indent, encoding);
        }

        public OptionalAttributeXmlWriter startElement(String name) throws IOException {
            super.startElement(name);
            return this;
        }

        public OptionalAttributeXmlWriter attribute(String name, String value) throws IOException {
            if (value != null) {
                super.attribute(name, value);
            }
            return this;
        }

        public OptionalAttributeXmlWriter attribute(String name, String value, String defaultValue) throws IOException {
            super.attribute(name, value == null ? defaultValue : value);
            return this;
        }
    }
}

