/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.ivy.internal;

import java.io.File;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Project;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.publish.PublicationContainer;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.ivy.internal.publication.IvyPublicationInternal;
import org.gradle.api.publish.ivy.tasks.GenerateIvyDescriptor;
import org.gradle.api.publish.ivy.tasks.PublishToIvyRepository;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.model.ModelRule;

public class IvyPublicationTasksModelRule
extends ModelRule {
    private final Project project;

    public IvyPublicationTasksModelRule(Project project) {
        this.project = project;
    }

    public void createTasks(TaskContainer tasks, PublishingExtension publishingExtension) {
        PublicationContainer publications = publishingExtension.getPublications();
        RepositoryHandler repositories = publishingExtension.getRepositories();
        for (final IvyPublicationInternal publication : publications.withType(IvyPublicationInternal.class)) {
            String publicationName = publication.getName();
            String descriptorTaskName = String.format("generateDescriptorFileFor%sPublication", StringUtils.capitalize((String)publicationName));
            GenerateIvyDescriptor descriptorTask = (GenerateIvyDescriptor)tasks.create(descriptorTaskName, GenerateIvyDescriptor.class);
            descriptorTask.setDescription(String.format("Generates the Ivy Module Descriptor XML file for publication '%s'.", publication.getName()));
            descriptorTask.setGroup("publishing");
            descriptorTask.setDescriptor(publication.getDescriptor());
            ConventionMapping descriptorTaskConventionMapping = new DslObject((Object)descriptorTask).getConventionMapping();
            descriptorTaskConventionMapping.map("destination", (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return new File(IvyPublicationTasksModelRule.this.project.getBuildDir(), "publications/" + publication.getName() + "/ivy.xml");
                }
            });
            publication.setDescriptorFile(descriptorTask.getOutputs().getFiles());
            for (IvyArtifactRepository repository : repositories.withType(IvyArtifactRepository.class)) {
                String repositoryName = repository.getName();
                String publishTaskName = String.format("publish%sPublicationTo%sRepository", StringUtils.capitalize((String)publicationName), StringUtils.capitalize((String)repositoryName));
                PublishToIvyRepository publishTask = (PublishToIvyRepository)tasks.create(publishTaskName, PublishToIvyRepository.class);
                publishTask.setPublication(publication);
                publishTask.setRepository(repository);
                publishTask.setGroup("publishing");
                publishTask.setDescription(String.format("Publishes Ivy publication '%s' to Ivy repository '%s'.", publicationName, repositoryName));
                tasks.getByName("publish").dependsOn(new Object[]{publishTask});
            }
        }
    }
}

