/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.metadata;

import java.io.Serializable;
import java.net.URI;
import java.util.Date;
import org.gradle.api.Nullable;
import org.gradle.internal.hash.HashValue;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;

public class DefaultExternalResourceMetaData
implements ExternalResourceMetaData,
Serializable {
    private final URI location;
    private final Date lastModified;
    private final long contentLength;
    private final String etag;
    private final String sha1;

    public DefaultExternalResourceMetaData(URI location) {
        this(location, -1L, -1L, null, null);
    }

    public DefaultExternalResourceMetaData(URI location, long lastModified, long contentLength, @Nullable String etag, @Nullable HashValue sha1) {
        this(location, lastModified > 0L ? new Date(lastModified) : null, contentLength, etag, sha1);
    }

    public DefaultExternalResourceMetaData(URI location, @Nullable Date lastModified, long contentLength, @Nullable String etag, @Nullable HashValue sha1) {
        this.location = location;
        this.lastModified = lastModified;
        this.contentLength = contentLength;
        this.etag = etag;
        this.sha1 = sha1 == null ? null : sha1.asHexString();
    }

    public URI getLocation() {
        return this.location;
    }

    @Nullable
    public Date getLastModified() {
        return this.lastModified;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    @Nullable
    public String getEtag() {
        return this.etag;
    }

    public HashValue getSha1() {
        return this.sha1 == null ? null : HashValue.parse((String)this.sha1);
    }
}

