/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URLConnection;
import org.apache.commons.io.IOUtils;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.resource.Resource;
import org.gradle.internal.resource.ResourceException;
import org.gradle.internal.resource.ResourceNotFoundException;
import org.gradle.util.GradleVersion;

public class UriResource
implements Resource {
    private final File sourceFile;
    private final URI sourceUri;
    private final String description;

    public UriResource(String description, File sourceFile) {
        this.description = description;
        this.sourceFile = this.canonicalise(sourceFile);
        this.sourceUri = sourceFile.toURI();
    }

    private File canonicalise(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return file.getAbsoluteFile();
        }
    }

    public UriResource(String description, URI sourceUri) {
        this.description = description;
        this.sourceFile = sourceUri.getScheme().equals("file") ? this.canonicalise(new File(sourceUri.getPath())) : null;
        this.sourceUri = sourceUri;
    }

    public String getDisplayName() {
        return String.format("%s '%s'", this.description, this.sourceFile != null ? this.sourceFile.getAbsolutePath() : this.sourceUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getText() {
        String string;
        if (this.sourceFile != null && this.sourceFile.isDirectory()) {
            throw new ResourceException(String.format("Could not read %s as it is a directory.", this.getDisplayName()));
        }
        Reader reader = this.getInputStream(this.sourceUri);
        try {
            string = IOUtils.toString((Reader)reader);
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw new ResourceNotFoundException(String.format("Could not read %s as it does not exist.", this.getDisplayName()));
            }
            catch (Exception e) {
                throw new ResourceException(String.format("Could not read %s.", this.getDisplayName()), e);
            }
        }
        reader.close();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getExists() {
        boolean bl;
        Reader reader = this.getInputStream(this.sourceUri);
        try {
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                throw throwable;
            }
            catch (FileNotFoundException e) {
                return false;
            }
            catch (Exception e) {
                throw new ResourceException(String.format("Could not determine if %s exists.", this.getDisplayName()), e);
            }
        }
        reader.close();
        return bl;
    }

    private Reader getInputStream(URI url) throws IOException {
        URLConnection urlConnection = url.toURL().openConnection();
        urlConnection.setRequestProperty("User-Agent", UriResource.getUserAgentString());
        urlConnection.connect();
        String charset = UriResource.extractCharacterEncoding(urlConnection.getContentType(), "utf-8");
        return new InputStreamReader(urlConnection.getInputStream(), charset);
    }

    public File getFile() {
        return this.sourceFile;
    }

    public URI getURI() {
        return this.sourceUri;
    }

    public static String extractCharacterEncoding(String contentType, String defaultEncoding) {
        if (contentType == null) {
            return defaultEncoding;
        }
        int pos = UriResource.findFirstParameter(0, contentType);
        if (pos == -1) {
            return defaultEncoding;
        }
        StringBuilder paramName = new StringBuilder();
        StringBuilder paramValue = new StringBuilder();
        pos = UriResource.findNextParameter(pos, contentType, paramName, paramValue);
        while (pos != -1) {
            if (paramName.toString().equals("charset") && paramValue.length() > 0) {
                return paramValue.toString();
            }
            pos = UriResource.findNextParameter(pos, contentType, paramName, paramValue);
        }
        return defaultEncoding;
    }

    private static int findFirstParameter(int pos, String contentType) {
        int index = contentType.indexOf(59, pos);
        if (index < 0) {
            return -1;
        }
        return index + 1;
    }

    private static int findNextParameter(int pos, String contentType, StringBuilder paramName, StringBuilder paramValue) {
        int endValue;
        if (pos >= contentType.length()) {
            return -1;
        }
        paramName.setLength(0);
        paramValue.setLength(0);
        int separator = contentType.indexOf("=", pos);
        if (separator < 0) {
            separator = contentType.length();
        }
        paramName.append(contentType.substring(pos, separator).trim());
        if (separator >= contentType.length() - 1) {
            return contentType.length();
        }
        int startValue = separator + 1;
        if (contentType.charAt(startValue) == '\"') {
            int i = ++startValue;
            while (i < contentType.length()) {
                char ch = contentType.charAt(i);
                if (ch == '\\' && i < contentType.length() - 1 && contentType.charAt(i + 1) == '\"') {
                    paramValue.append('\"');
                    i += 2;
                    continue;
                }
                if (ch == '\"') break;
                paramValue.append(ch);
                ++i;
            }
            endValue = i + 1;
        } else {
            endValue = contentType.indexOf(59, startValue);
            if (endValue < 0) {
                endValue = contentType.length();
            }
            paramValue.append(contentType.substring(startValue, endValue));
        }
        if (endValue < contentType.length() && contentType.charAt(endValue) == ';') {
            ++endValue;
        }
        return endValue;
    }

    public static String getUserAgentString() {
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        String osArch = System.getProperty("os.arch");
        String javaVendor = System.getProperty("java.vendor");
        String javaVersion = SystemProperties.getJavaVersion();
        String javaVendorVersion = System.getProperty("java.vm.version");
        return String.format("Gradle/%s (%s;%s;%s) (%s;%s;%s)", GradleVersion.current().getVersion(), osName, osVersion, osArch, javaVendor, javaVersion, javaVendorVersion);
    }
}

