/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource;

import com.google.common.base.Objects;
import java.net.URI;
import java.net.URISyntaxException;
import org.gradle.internal.UncheckedException;

public class ExternalResourceName {
    private final String encodedRoot;
    private final String path;

    public ExternalResourceName(URI uri) {
        if (uri.getPath() == null) {
            throw new IllegalArgumentException(String.format("Cannot create resource name from non-hierarchical URI '%s'.", uri.toString()));
        }
        this.encodedRoot = this.encodeRoot(uri);
        this.path = uri.getPath();
    }

    public ExternalResourceName(String path) {
        this.encodedRoot = null;
        this.path = path;
    }

    private ExternalResourceName(String encodedRoot, String path) {
        this.encodedRoot = encodedRoot;
        this.path = path;
    }

    public ExternalResourceName(URI parent, String path) {
        if (parent.getPath() == null) {
            throw new IllegalArgumentException(String.format("Cannot create resource name from non-hierarchical URI '%s'.", parent.toString()));
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        String newPath = path.length() == 0 ? parent.getPath() : (parent.getPath().endsWith("/") ? parent.getPath() + path : parent.getPath() + "/" + path);
        this.encodedRoot = this.encodeRoot(parent);
        this.path = newPath;
    }

    private String encodeRoot(URI uri) {
        StringBuilder builder = new StringBuilder();
        if (uri.getScheme() != null) {
            builder.append(uri.getScheme());
            builder.append(":");
        }
        if (uri.getHost() != null) {
            builder.append("//");
            builder.append(uri.getHost());
        }
        if (uri.getPort() > 0) {
            builder.append(":");
            builder.append(uri.getPort());
        }
        return builder.toString();
    }

    public String getDisplayName() {
        return this.getDecoded();
    }

    public String toString() {
        return this.getDisplayName();
    }

    public URI getUri() {
        try {
            if (this.encodedRoot == null) {
                return new URI(this.encode(this.path, false));
            }
            return new URI(this.encodedRoot + this.encode(this.path, true));
        }
        catch (URISyntaxException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private String encode(String path, boolean isPathSeg) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            char ch = path.charAt(i);
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9') {
                builder.append(ch);
                continue;
            }
            if (ch == '/' || ch == '@' || isPathSeg && ch == ':' || ch == '.' || ch == '-' || ch == '_' || ch == '~' || ch == '!' || ch == '$' || ch == '&' || ch == '\'' || ch == '(' || ch == ')' || ch == '*' || ch == '+' || ch == ',' || ch == ';' || ch == '=') {
                builder.append(ch);
                continue;
            }
            if (ch <= '\u007f') {
                this.escapeByte(ch, builder);
                continue;
            }
            if (ch <= '\u07ff') {
                this.escapeByte(0xC0 | ch >> 6 & 0x1F, builder);
                this.escapeByte(0x80 | ch & 0x3F, builder);
                continue;
            }
            this.escapeByte(0xE0 | ch >> 12 & 0x1F, builder);
            this.escapeByte(0x80 | ch >> 6 & 0x3F, builder);
            this.escapeByte(0x80 | ch & 0x3F, builder);
        }
        return builder.toString();
    }

    private void escapeByte(int ch, StringBuilder builder) {
        builder.append('%');
        builder.append(Character.toUpperCase(Character.forDigit(ch >> 4 & 0xFF, 16)));
        builder.append(Character.toUpperCase(Character.forDigit(ch & 0xF, 16)));
    }

    public String getDecoded() {
        if (this.encodedRoot == null) {
            return this.path;
        }
        return this.encodedRoot + this.path;
    }

    public ExternalResourceName getRoot() {
        return new ExternalResourceName(this.encodedRoot, this.path.startsWith("/") ? "/" : "");
    }

    public String getPath() {
        return this.path;
    }

    public ExternalResourceName resolve(String path) {
        String newPath = path.startsWith("/") ? path : (this.path.endsWith("/") || this.path.length() == 0 ? this.path + path : this.path + "/" + path);
        return new ExternalResourceName(this.encodedRoot, newPath);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        ExternalResourceName other = (ExternalResourceName)obj;
        return Objects.equal((Object)this.encodedRoot, (Object)other.encodedRoot) && this.path.equals(other.path);
    }

    public int hashCode() {
        return (this.encodedRoot == null ? 0 : this.encodedRoot.hashCode()) ^ this.path.hashCode();
    }
}

