/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration;

import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.internal.tasks.options.Option;
import org.gradle.api.internal.tasks.options.OptionReader;
import org.gradle.api.tasks.TaskAction;
import org.gradle.configuration.TaskDetailPrinter;
import org.gradle.execution.TaskSelector;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.logging.StyledTextOutput;
import org.gradle.logging.StyledTextOutputFactory;
import org.gradle.util.GradleVersion;

public class Help
extends DefaultTask {
    private String taskPath;

    @Inject
    protected StyledTextOutputFactory getTextOutputFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected BuildClientMetaData getClientMetaData() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected TaskSelector getTaskSelector() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected OptionReader getOptionReader() {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    void displayHelp() {
        StyledTextOutput output = this.getTextOutputFactory().create(Help.class);
        BuildClientMetaData metaData = this.getClientMetaData();
        if (this.taskPath != null) {
            this.printTaskHelp(output);
        } else {
            this.printDefaultHelp(output, metaData);
        }
    }

    private void printTaskHelp(StyledTextOutput output) {
        TaskSelector selector = this.getTaskSelector();
        TaskSelector.TaskSelection selection = selector.getSelection(this.taskPath);
        OptionReader optionReader = this.getOptionReader();
        TaskDetailPrinter taskDetailPrinter = new TaskDetailPrinter(this.taskPath, selection, optionReader);
        taskDetailPrinter.print(output);
    }

    private void printDefaultHelp(StyledTextOutput output, BuildClientMetaData metaData) {
        output.println();
        output.formatln("Welcome to Gradle %s.", new Object[]{GradleVersion.current().getVersion()});
        output.println();
        output.text((Object)"To run a build, run ");
        metaData.describeCommand((Appendable)output.withStyle(StyledTextOutput.Style.UserInput), new String[]{"<task> ..."});
        output.println();
        output.println();
        output.text((Object)"To see a list of available tasks, run ");
        metaData.describeCommand((Appendable)output.withStyle(StyledTextOutput.Style.UserInput), new String[]{"tasks"});
        output.println();
        output.println();
        output.text((Object)"To see a list of command-line options, run ");
        metaData.describeCommand((Appendable)output.withStyle(StyledTextOutput.Style.UserInput), new String[]{"--help"});
        output.println();
    }

    @Option(option="task", description="The task to show help for.")
    public void setTaskPath(String taskPath) {
        this.taskPath = taskPath;
    }
}

