/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal.dependencies;

import java.io.IOException;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.tasks.diagnostics.internal.DependencyReportRenderer;
import org.gradle.api.tasks.diagnostics.internal.TextReportRenderer;
import org.gradle.api.tasks.diagnostics.internal.graph.DependencyGraphRenderer;
import org.gradle.api.tasks.diagnostics.internal.graph.SimpleNodeRenderer;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RenderableDependency;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RenderableModuleResult;
import org.gradle.internal.graph.GraphRenderer;
import org.gradle.logging.StyledTextOutput;
import org.gradle.util.GUtil;

public class AsciiDependencyReportRenderer
extends TextReportRenderer
implements DependencyReportRenderer {
    private boolean hasConfigs;
    DependencyGraphRenderer dependencyGraphRenderer;

    public void startProject(Project project) {
        super.startProject(project);
        this.hasConfigs = false;
    }

    public void completeProject(Project project) {
        if (!this.hasConfigs) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Info).println((Object)"No configurations");
        }
        super.completeProject(project);
    }

    public void startConfiguration(final Configuration configuration) {
        if (this.hasConfigs) {
            this.getTextOutput().println();
        }
        this.hasConfigs = true;
        GraphRenderer renderer = new GraphRenderer(this.getTextOutput());
        renderer.visit((Action)new Action<StyledTextOutput>(){

            public void execute(StyledTextOutput styledTextOutput) {
                AsciiDependencyReportRenderer.this.getTextOutput().withStyle(StyledTextOutput.Style.Identifier).text((Object)configuration.getName());
                AsciiDependencyReportRenderer.this.getTextOutput().withStyle(StyledTextOutput.Style.Description).text((Object)AsciiDependencyReportRenderer.this.getDescription(configuration));
            }
        }, true);
        SimpleNodeRenderer nodeRenderer = new SimpleNodeRenderer();
        this.dependencyGraphRenderer = new DependencyGraphRenderer(renderer, nodeRenderer);
    }

    private String getDescription(Configuration configuration) {
        return GUtil.isTrue((Object)configuration.getDescription()) ? " - " + configuration.getDescription() : "";
    }

    public void completeConfiguration(Configuration configuration) {
    }

    public void render(Configuration configuration) throws IOException {
        ResolutionResult result = configuration.getIncoming().getResolutionResult();
        RenderableModuleResult root = new RenderableModuleResult(result.getRoot());
        this.renderNow(root);
    }

    void renderNow(RenderableDependency root) {
        if (root.getChildren().isEmpty()) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Info).text((Object)"No dependencies");
            this.getTextOutput().println();
            return;
        }
        this.dependencyGraphRenderer.render(root);
    }

    public void complete() throws IOException {
        if (this.dependencyGraphRenderer != null) {
            this.dependencyGraphRenderer.printLegend();
        }
        super.complete();
    }
}

