/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.gradle.api.Project;
import org.gradle.api.tasks.diagnostics.internal.ReportRenderer;
import org.gradle.logging.StyledTextOutput;
import org.gradle.logging.internal.StreamingStyledTextOutput;
import org.gradle.util.GUtil;

public class TextReportRenderer
implements ReportRenderer {
    public static final String SEPARATOR = "------------------------------------------------------------";
    private StyledTextOutput textOutput;
    private boolean close;

    public void setOutput(StyledTextOutput textOutput) {
        this.setWriter(textOutput, false);
    }

    public void setOutputFile(File file) throws IOException {
        this.cleanupWriter();
        this.setWriter((StyledTextOutput)new StreamingStyledTextOutput((Appendable)new BufferedWriter(new FileWriter(file))), true);
    }

    public void startProject(Project project) {
        String header = this.createHeader(project);
        this.writeHeading(header);
    }

    protected String createHeader(Project project) {
        String header = project.getRootProject() == project ? "Root project" : String.format("Project %s", project.getPath());
        if (GUtil.isTrue((Object)project.getDescription())) {
            header = header + " - " + project.getDescription();
        }
        return header;
    }

    public void completeProject(Project project) {
    }

    public void complete() throws IOException {
        this.cleanupWriter();
    }

    private void setWriter(StyledTextOutput styledTextOutput, boolean close) {
        this.textOutput = styledTextOutput;
        this.close = close;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupWriter() throws IOException {
        try {
            if (this.textOutput != null && this.close) {
                ((Closeable)this.textOutput).close();
            }
        }
        finally {
            this.textOutput = null;
        }
    }

    public StyledTextOutput getTextOutput() {
        return this.textOutput;
    }

    public void writeHeading(String heading) {
        this.textOutput.println().style(StyledTextOutput.Style.Header);
        this.textOutput.println((Object)SEPARATOR);
        this.textOutput.println((Object)heading);
        this.textOutput.text((Object)SEPARATOR);
        this.textOutput.style(StyledTextOutput.Style.Normal);
        this.textOutput.println().println();
    }

    public void writeSubheading(String heading) {
        this.getTextOutput().style(StyledTextOutput.Style.Header).println((Object)heading);
        for (int i = 0; i < heading.length(); ++i) {
            this.getTextOutput().text((Object)"-");
        }
        this.getTextOutput().style(StyledTextOutput.Style.Normal).println();
    }
}

