/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.toolchain.internal.tools;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.GradleException;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.text.TreeFormatter;
import org.gradle.nativebinaries.toolchain.internal.ToolType;
import org.gradle.nativebinaries.toolchain.internal.gcc.CommandLineToolSearchResult;
import org.gradle.util.TreeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolSearchPath {
    private final Map<String, File> executables = new HashMap<String, File>();
    private final List<File> pathEntries = new ArrayList<File>();
    private final OperatingSystem operatingSystem;

    public ToolSearchPath(OperatingSystem operatingSystem) {
        this.operatingSystem = operatingSystem;
    }

    public List<File> getPath() {
        return this.pathEntries;
    }

    public void setPath(List<File> pathEntries) {
        this.pathEntries.clear();
        this.pathEntries.addAll(pathEntries);
        this.executables.clear();
    }

    public void path(File pathEntry) {
        this.pathEntries.add(pathEntry);
        this.executables.clear();
    }

    public CommandLineToolSearchResult locate(ToolType key, String exeName) {
        File executable = this.executables.get(exeName);
        if (executable == null && (executable = this.findExecutable(this.operatingSystem, exeName)) != null) {
            this.executables.put(exeName, executable);
        }
        CommandLineToolSearchResult result = executable == null || !executable.isFile() ? new MissingTool(key, exeName, this.pathEntries) : new FoundTool(executable);
        return result;
    }

    protected File findExecutable(OperatingSystem operatingSystem, String name) {
        if (!this.pathEntries.isEmpty()) {
            String exeName = operatingSystem.getExecutableName(name);
            for (File pathEntry : this.pathEntries) {
                File candidate = new File(pathEntry, exeName);
                if (!candidate.isFile()) continue;
                return candidate;
            }
            return null;
        }
        return operatingSystem.findInPath(name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MissingTool
    implements CommandLineToolSearchResult {
        private final ToolType type;
        private final String exeName;
        private final List<File> path;

        private MissingTool(ToolType type, String exeName, List<File> path) {
            this.type = type;
            this.exeName = exeName;
            this.path = path;
        }

        @Override
        public void explain(TreeVisitor<? super String> visitor) {
            if (this.path.isEmpty()) {
                visitor.node((Object)String.format("Could not find %s '%s' in system path.", this.type.getToolName(), this.exeName));
            } else {
                visitor.node((Object)String.format("Could not find %s '%s'. Searched in", this.type.getToolName(), this.exeName));
                visitor.startChildren();
                for (File location : this.path) {
                    visitor.node((Object)location.toString());
                }
                visitor.endChildren();
            }
        }

        @Override
        public File getTool() {
            TreeFormatter formatter = new TreeFormatter();
            this.explain((TreeVisitor<? super String>)formatter);
            throw new GradleException(formatter.toString());
        }

        @Override
        public boolean isAvailable() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FoundTool
    implements CommandLineToolSearchResult {
        private final File tool;

        private FoundTool(File tool) {
            this.tool = tool;
        }

        @Override
        public boolean isAvailable() {
            return true;
        }

        @Override
        public File getTool() {
            return this.tool;
        }

        @Override
        public void explain(TreeVisitor<? super String> visitor) {
        }
    }
}

