/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.toolchain.internal.msvcpp;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.api.internal.tasks.SimpleWorkResult;
import org.gradle.api.internal.tasks.compile.Compiler;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.FileUtils;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.nativebinaries.internal.CompilerOutputFileNamingScheme;
import org.gradle.nativebinaries.language.rc.internal.WindowsResourceCompileSpec;
import org.gradle.nativebinaries.toolchain.internal.ArgsTransformer;
import org.gradle.nativebinaries.toolchain.internal.CommandLineTool;
import org.gradle.nativebinaries.toolchain.internal.CommandLineToolInvocation;
import org.gradle.nativebinaries.toolchain.internal.MacroArgsConverter;
import org.gradle.nativebinaries.toolchain.internal.MutableCommandLineToolInvocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowsResourceCompiler
implements Compiler<WindowsResourceCompileSpec> {
    private final CommandLineTool commandLineTool;
    private final Transformer<WindowsResourceCompileSpec, WindowsResourceCompileSpec> specTransformer;
    private final CommandLineToolInvocation baseInvocation;

    WindowsResourceCompiler(CommandLineTool commandLineTool, CommandLineToolInvocation invocation, Transformer<WindowsResourceCompileSpec, WindowsResourceCompileSpec> specTransformer) {
        this.commandLineTool = commandLineTool;
        this.specTransformer = specTransformer;
        this.baseInvocation = invocation;
    }

    public WorkResult execute(WindowsResourceCompileSpec spec) {
        boolean windowsPathLimitation = OperatingSystem.current().isWindows();
        MutableCommandLineToolInvocation invocation = this.baseInvocation.copy();
        spec = (WindowsResourceCompileSpec)this.specTransformer.transform((Object)spec);
        for (File sourceFile : spec.getSourceFiles()) {
            RcCompilerArgsTransformer argsTransformer = new RcCompilerArgsTransformer(sourceFile, windowsPathLimitation);
            invocation.setArgs(argsTransformer.transform(spec));
            invocation.setWorkDirectory(spec.getObjectFileDir());
            this.commandLineTool.execute(invocation);
        }
        return new SimpleWorkResult(!spec.getSourceFiles().isEmpty());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RcCompilerArgsTransformer
    implements ArgsTransformer<WindowsResourceCompileSpec> {
        private final File inputFile;
        private boolean windowsPathLengthLimitation;

        public RcCompilerArgsTransformer(File inputFile, boolean windowsPathLengthLimitation) {
            this.inputFile = inputFile;
            this.windowsPathLengthLimitation = windowsPathLengthLimitation;
        }

        public List<String> transform(WindowsResourceCompileSpec spec) {
            ArrayList<String> args = new ArrayList<String>();
            args.add("/nologo");
            args.add("/fo");
            args.add(this.getOutputFile(spec).getAbsolutePath());
            for (String macroArg : new MacroArgsConverter().transform(spec.getMacros())) {
                args.add("/D" + macroArg);
            }
            args.addAll(spec.getAllArgs());
            for (File file : spec.getIncludeRoots()) {
                args.add("/I" + file.getAbsolutePath());
            }
            args.add(this.inputFile.getAbsolutePath());
            return args;
        }

        private File getOutputFile(WindowsResourceCompileSpec spec) {
            File outputFile = new CompilerOutputFileNamingScheme().withObjectFileNameSuffix(".res").withOutputBaseFolder(spec.getObjectFileDir()).map(this.inputFile);
            File outputDirectory = outputFile.getParentFile();
            if (!outputDirectory.exists()) {
                outputDirectory.mkdirs();
            }
            return this.windowsPathLengthLimitation ? FileUtils.assertInWindowsPathLengthLimitation((File)outputFile) : outputFile;
        }
    }
}

