/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.toolchain.internal.msvcpp;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.api.internal.tasks.SimpleWorkResult;
import org.gradle.api.internal.tasks.compile.Compiler;
import org.gradle.api.tasks.WorkResult;
import org.gradle.nativebinaries.internal.LinkerSpec;
import org.gradle.nativebinaries.internal.SharedLibraryLinkerSpec;
import org.gradle.nativebinaries.toolchain.internal.ArgsTransformer;
import org.gradle.nativebinaries.toolchain.internal.CommandLineTool;
import org.gradle.nativebinaries.toolchain.internal.CommandLineToolInvocation;
import org.gradle.nativebinaries.toolchain.internal.MutableCommandLineToolInvocation;
import org.gradle.nativebinaries.toolchain.internal.msvcpp.EscapeUserArgs;
import org.gradle.nativebinaries.toolchain.internal.msvcpp.VisualCppOptionsFileArgTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LinkExeLinker
implements Compiler<LinkerSpec> {
    private final CommandLineTool commandLineTool;
    private final Transformer<LinkerSpec, LinkerSpec> specTransformer;
    private final ArgsTransformer<LinkerSpec> argsTransformer = new LinkerArgsTransformer();
    private final CommandLineToolInvocation baseInvocation;

    public LinkExeLinker(CommandLineTool commandLineTool, CommandLineToolInvocation invocation, Transformer<LinkerSpec, LinkerSpec> specTransformer) {
        this.commandLineTool = commandLineTool;
        this.baseInvocation = invocation;
        this.specTransformer = specTransformer;
    }

    public WorkResult execute(LinkerSpec spec) {
        MutableCommandLineToolInvocation invocation = this.baseInvocation.copy();
        invocation.addPostArgsAction(new VisualCppOptionsFileArgTransformer(spec.getTempDir()));
        invocation.setArgs((List)this.argsTransformer.transform(this.specTransformer.transform((Object)spec)));
        this.commandLineTool.execute(invocation);
        return new SimpleWorkResult(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LinkerArgsTransformer
    implements ArgsTransformer<LinkerSpec> {
        private LinkerArgsTransformer() {
        }

        public List<String> transform(LinkerSpec spec) {
            ArrayList<String> args = new ArrayList<String>();
            args.addAll(EscapeUserArgs.escapeUserArgs(spec.getAllArgs()));
            args.add("/OUT:" + spec.getOutputFile().getAbsolutePath());
            args.add("/NOLOGO");
            if (spec instanceof SharedLibraryLinkerSpec) {
                args.add("/DLL");
            }
            for (File pathEntry : spec.getLibraryPath()) {
                args.add("/LIBPATH:" + pathEntry.getAbsolutePath());
            }
            for (File file : spec.getObjectFiles()) {
                args.add(file.getAbsolutePath());
            }
            for (File file : spec.getLibraries()) {
                args.add(file.getAbsolutePath());
            }
            return args;
        }
    }
}

