/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.toolchain.internal.msvcpp;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.rubygrapefruit.platform.MissingRegistryEntryException;
import net.rubygrapefruit.platform.SystemInfo;
import net.rubygrapefruit.platform.WindowsRegistry;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.nativebinaries.platform.Architecture;
import org.gradle.nativebinaries.platform.internal.ArchitectureNotationParser;
import org.gradle.nativebinaries.toolchain.internal.msvcpp.VisualCppInstall;
import org.gradle.nativebinaries.toolchain.internal.msvcpp.VisualStudioInstall;
import org.gradle.nativebinaries.toolchain.internal.msvcpp.VisualStudioLocator;
import org.gradle.util.GFileUtils;
import org.gradle.util.TreeVisitor;
import org.gradle.util.VersionNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultVisualStudioLocator
implements VisualStudioLocator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultVisualStudioLocator.class);
    private static final String[] REGISTRY_BASEPATHS = new String[]{"SOFTWARE\\", "SOFTWARE\\Wow6432Node\\"};
    private static final String REGISTRY_ROOTPATH_VC = "Microsoft\\VisualStudio\\SxS\\VC7";
    private static final String PATH_COMMON = "Common7/";
    private static final String PATH_COMMONTOOLS = "Common7/Tools/";
    private static final String PATH_COMMONIDE = "Common7/IDE/";
    private static final String PATH_BIN = "bin/";
    private static final String PATH_INCLUDE = "include/";
    private static final String COMPILER_FILENAME = "cl.exe";
    private static final String ARCHITECTURE_AMD64 = "amd64";
    private static final String ARCHITECTURE_X86 = "x86";
    private static final String ARCHITECTURE_ARM = "arm";
    private static final String ARCHITECTURE_IA64 = "ia-64";
    private static final String BINPATH_AMD64_AMD64 = "bin/amd64";
    private static final String BINPATH_AMD64_ARM = "bin/amd64_arm";
    private static final String BINPATH_AMD64_X86 = "bin/amd64_x86";
    private static final String BINPATH_X86_AMD64 = "bin/x86_amd64";
    private static final String BINPATH_X86_ARM = "bin/x86_arm";
    private static final String BINPATH_X86_IA64 = "bin/x86_ia64";
    private static final String BINPATH_X86_X86 = "bin";
    private static final String LIBPATH_AMD64 = "lib/amd64";
    private static final String LIBPATH_ARM = "lib/arm";
    private static final String LIBPATH_IA64 = "lib/ia64";
    private static final String LIBPATH_X86 = "lib";
    private static final String ASSEMBLER_FILENAME_AMD64 = "ml64.exe";
    private static final String ASSEMBLER_FILENAME_ARM = "armasm.exe";
    private static final String ASSEMBLER_FILENAME_IA64 = "ias.exe";
    private static final String ASSEMBLER_FILENAME_X86 = "ml.exe";
    private static final String DEFINE_ARMPARTITIONAVAILABLE = "_ARM_WINAPI_PARTITION_DESKTOP_SDK_AVAILABLE";
    private final Map<File, VisualStudioInstall> foundInstalls = new HashMap<File, VisualStudioInstall>();
    private final OperatingSystem os;
    private final WindowsRegistry windowsRegistry;
    private final SystemInfo systemInfo;
    private VisualStudioInstall pathInstall;
    private boolean initialised;

    public DefaultVisualStudioLocator(OperatingSystem os, WindowsRegistry windowsRegistry, SystemInfo systemInfo) {
        this.os = os;
        this.windowsRegistry = windowsRegistry;
        this.systemInfo = systemInfo;
    }

    public VisualStudioLocator.SearchResult locateVisualStudioInstalls(File candidate) {
        if (!this.initialised) {
            this.locateInstallsInRegistry();
            this.locateInstallInPath();
            this.initialised = true;
        }
        if (candidate != null) {
            return this.locateUserSpecifiedInstall(candidate);
        }
        return this.determineDefaultInstall();
    }

    private void locateInstallsInRegistry() {
        for (String baseKey : REGISTRY_BASEPATHS) {
            this.locateInstallsInRegistry(baseKey);
        }
    }

    private void locateInstallsInRegistry(String baseKey) {
        List visualCppVersions;
        try {
            visualCppVersions = this.windowsRegistry.getValueNames(WindowsRegistry.Key.HKEY_LOCAL_MACHINE, baseKey + REGISTRY_ROOTPATH_VC);
        }
        catch (MissingRegistryEntryException e) {
            return;
        }
        for (String valueName : visualCppVersions) {
            if (!valueName.matches("\\d+\\.\\d+")) continue;
            File visualCppDir = new File(this.windowsRegistry.getStringValue(WindowsRegistry.Key.HKEY_LOCAL_MACHINE, baseKey + REGISTRY_ROOTPATH_VC, valueName));
            visualCppDir = GFileUtils.canonicalise((File)visualCppDir);
            File visualStudioDir = visualCppDir.getParentFile();
            if (DefaultVisualStudioLocator.isVisualCpp(visualCppDir) && DefaultVisualStudioLocator.isVisualStudio(visualStudioDir)) {
                LOGGER.debug("Found Visual C++ {} at {}", (Object)valueName, (Object)visualCppDir);
                VersionNumber version = VersionNumber.parse((String)valueName);
                VisualCppInstall visualCpp = this.buildVisualCppInstall("Visual C++ " + valueName, visualStudioDir, visualCppDir, version);
                VisualStudioInstall visualStudio = new VisualStudioInstall(visualStudioDir, visualCpp);
                this.foundInstalls.put(visualStudioDir, visualStudio);
                continue;
            }
            LOGGER.debug("Ignoring candidate Visual C++ directory {} as it does not look like a Visual C++ installation.", (Object)visualCppDir);
        }
    }

    private void locateInstallInPath() {
        File compilerInPath = this.os.findInPath(COMPILER_FILENAME);
        if (compilerInPath == null) {
            LOGGER.debug("No visual c++ compiler found in system path.");
            return;
        }
        File visualCppDir = GFileUtils.canonicalise((File)compilerInPath.getParentFile().getParentFile());
        if (!DefaultVisualStudioLocator.isVisualCpp(visualCppDir) && !DefaultVisualStudioLocator.isVisualCpp(visualCppDir = visualCppDir.getParentFile())) {
            LOGGER.debug("Ignoring candidate Visual C++ install for {} as it does not look like a Visual C++ installation.", (Object)compilerInPath);
            return;
        }
        LOGGER.debug("Found Visual C++ install {} using system path", (Object)visualCppDir);
        File visualStudioDir = visualCppDir.getParentFile();
        if (!this.foundInstalls.containsKey(visualStudioDir)) {
            VisualCppInstall visualCpp = this.buildVisualCppInstall("Visual C++ from system path", visualStudioDir, visualCppDir, VersionNumber.UNKNOWN);
            VisualStudioInstall visualStudio = new VisualStudioInstall(visualStudioDir, visualCpp);
            this.foundInstalls.put(visualStudioDir, visualStudio);
        }
        this.pathInstall = this.foundInstalls.get(visualStudioDir);
    }

    private VisualStudioLocator.SearchResult locateUserSpecifiedInstall(File candidate) {
        File visualStudioDir = GFileUtils.canonicalise((File)candidate);
        File visualCppDir = new File(visualStudioDir, "VC");
        if (!DefaultVisualStudioLocator.isVisualStudio(visualStudioDir) || !DefaultVisualStudioLocator.isVisualCpp(visualCppDir)) {
            LOGGER.debug("Ignoring candidate Visual C++ install for {} as it does not look like a Visual C++ installation.", (Object)candidate);
            return new InstallNotFound(String.format("The specified installation directory '%s' does not appear to contain a Visual Studio installation.", candidate));
        }
        if (!this.foundInstalls.containsKey(visualStudioDir)) {
            VisualCppInstall visualCpp = this.buildVisualCppInstall("Visual C++ from user provided path", visualStudioDir, visualCppDir, VersionNumber.UNKNOWN);
            VisualStudioInstall visualStudio = new VisualStudioInstall(visualStudioDir, visualCpp);
            this.foundInstalls.put(visualStudioDir, visualStudio);
        }
        return new InstallFound(this.foundInstalls.get(visualStudioDir));
    }

    private VisualCppInstall buildVisualCppInstall(String name, File vsPath, File basePath, VersionNumber version) {
        ArrayList<File> pathsList;
        LinkedHashMap<String, String> definitionsList;
        File libPath;
        File binPath;
        Architecture architecture;
        int i;
        String[] asmFilenames;
        String[] libPaths;
        String[] binPaths;
        Architecture[] architectures;
        boolean isNativeAmd64 = this.systemInfo.getArchitecture() == SystemInfo.Architecture.amd64;
        HashMap<Architecture, List<File>> paths = new HashMap<Architecture, List<File>>();
        HashMap<Architecture, File> binaryPaths = new HashMap<Architecture, File>();
        HashMap<Architecture, File> libraryPaths = new HashMap<Architecture, File>();
        HashMap<Architecture, File> includePaths = new HashMap<Architecture, File>();
        HashMap<Architecture, String> assemblerFilenames = new HashMap<Architecture, String>();
        HashMap<Architecture, Map<String, String>> definitions = new HashMap<Architecture, Map<String, String>>();
        NotationParser<Object, Architecture> architectureParser = ArchitectureNotationParser.parser();
        Architecture amd64 = (Architecture)architectureParser.parseNotation((Object)ARCHITECTURE_AMD64);
        Architecture x86 = (Architecture)architectureParser.parseNotation((Object)ARCHITECTURE_X86);
        Architecture arm = (Architecture)architectureParser.parseNotation((Object)ARCHITECTURE_ARM);
        Architecture ia64 = (Architecture)architectureParser.parseNotation((Object)ARCHITECTURE_IA64);
        File includePath = new File(basePath, PATH_INCLUDE);
        File commonTools = new File(vsPath, PATH_COMMONTOOLS);
        File commonIde = new File(vsPath, PATH_COMMONIDE);
        if (isNativeAmd64) {
            architectures = new Architecture[]{amd64, x86, arm};
            binPaths = new String[]{BINPATH_AMD64_AMD64, BINPATH_AMD64_X86, BINPATH_AMD64_ARM};
            libPaths = new String[]{LIBPATH_AMD64, LIBPATH_X86, LIBPATH_ARM};
            asmFilenames = new String[]{ASSEMBLER_FILENAME_AMD64, ASSEMBLER_FILENAME_X86, ASSEMBLER_FILENAME_ARM};
            for (i = 0; i != architectures.length; ++i) {
                architecture = architectures[i];
                binPath = new File(basePath, binPaths[i]);
                libPath = new File(basePath, libPaths[i]);
                if (!binPath.isDirectory() || !libPath.isDirectory()) continue;
                definitionsList = new LinkedHashMap<String, String>();
                pathsList = new ArrayList<File>();
                pathsList.add(commonTools);
                pathsList.add(commonIde);
                if (architecture != amd64) {
                    pathsList.add(new File(basePath, binPaths[0]));
                }
                if (architecture == arm) {
                    definitionsList.put(DEFINE_ARMPARTITIONAVAILABLE, "1");
                }
                binaryPaths.put(architecture, binPath);
                libraryPaths.put(architecture, libPath);
                includePaths.put(architecture, includePath);
                assemblerFilenames.put(architecture, asmFilenames[i]);
                paths.put(architecture, pathsList);
                definitions.put(architecture, definitionsList);
            }
        }
        architectures = new Architecture[]{x86, amd64, ia64, arm};
        binPaths = new String[]{BINPATH_X86_X86, BINPATH_X86_AMD64, BINPATH_X86_IA64, BINPATH_X86_ARM};
        libPaths = new String[]{LIBPATH_X86, LIBPATH_AMD64, LIBPATH_IA64, LIBPATH_ARM};
        asmFilenames = new String[]{ASSEMBLER_FILENAME_X86, ASSEMBLER_FILENAME_AMD64, ASSEMBLER_FILENAME_IA64, ASSEMBLER_FILENAME_ARM};
        for (i = 0; i != architectures.length; ++i) {
            architecture = architectures[i];
            if (binaryPaths.containsKey(architecture)) continue;
            binPath = new File(basePath, binPaths[i]);
            libPath = new File(basePath, libPaths[i]);
            if (!binPath.isDirectory() || !libPath.isDirectory()) continue;
            definitionsList = new LinkedHashMap();
            pathsList = new ArrayList();
            pathsList.add(commonTools);
            pathsList.add(commonIde);
            if (architecture != x86) {
                pathsList.add(new File(basePath, binPaths[0]));
            }
            if (architecture == arm) {
                definitionsList.put(DEFINE_ARMPARTITIONAVAILABLE, "1");
            }
            binaryPaths.put(architecture, binPath);
            libraryPaths.put(architecture, libPath);
            includePaths.put(architecture, includePath);
            assemblerFilenames.put(architecture, asmFilenames[i]);
            paths.put(architecture, pathsList);
            definitions.put(architecture, definitionsList);
        }
        return new VisualCppInstall(name, version, x86, paths, binaryPaths, libraryPaths, includePaths, assemblerFilenames, definitions);
    }

    private VisualStudioLocator.SearchResult determineDefaultInstall() {
        if (this.pathInstall != null) {
            return new InstallFound(this.pathInstall);
        }
        VisualStudioInstall candidate = null;
        for (VisualStudioInstall visualStudio : this.foundInstalls.values()) {
            if (candidate != null && visualStudio.getVersion().compareTo(candidate.getVersion()) <= 0) continue;
            candidate = visualStudio;
        }
        return candidate == null ? new InstallNotFound("Could not locate a Visual Studio installation, using the Windows registry and system path.") : new InstallFound(candidate);
    }

    private static boolean isVisualStudio(File candidate) {
        return new File(candidate, PATH_COMMON).isDirectory() && DefaultVisualStudioLocator.isVisualCpp(new File(candidate, "VC"));
    }

    private static boolean isVisualCpp(File candidate) {
        return new File(candidate, "bin/cl.exe").isFile();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InstallNotFound
    implements VisualStudioLocator.SearchResult {
        private final String message;

        private InstallNotFound(String message) {
            this.message = message;
        }

        @Override
        public VisualStudioInstall getVisualStudio() {
            return null;
        }

        @Override
        public boolean isAvailable() {
            return false;
        }

        @Override
        public void explain(TreeVisitor<? super String> visitor) {
            visitor.node((Object)this.message);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InstallFound
    implements VisualStudioLocator.SearchResult {
        private final VisualStudioInstall install;

        public InstallFound(VisualStudioInstall install) {
            this.install = install;
        }

        @Override
        public VisualStudioInstall getVisualStudio() {
            return this.install;
        }

        @Override
        public boolean isAvailable() {
            return true;
        }

        @Override
        public void explain(TreeVisitor<? super String> visitor) {
        }
    }
}

