/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.toolchain.internal.gcc.version;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.Transformer;
import org.gradle.api.UncheckedIOException;
import org.gradle.nativebinaries.toolchain.internal.gcc.version.GccVersionResult;
import org.gradle.process.ExecResult;
import org.gradle.process.internal.ExecAction;
import org.gradle.process.internal.ExecActionFactory;
import org.gradle.util.TreeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GccVersionDeterminer
implements Transformer<GccVersionResult, File> {
    private static final Pattern DEFINE_PATTERN = Pattern.compile("\\s*#define\\s+(\\S+)\\s+(.*)");
    private final Transformer<String, File> outputProducer;

    public GccVersionDeterminer(ExecActionFactory execActionFactory) {
        this.outputProducer = new GccVersionOutputProducer(execActionFactory);
    }

    public GccVersionResult transform(File gccBinary) {
        String output = (String)this.outputProducer.transform((Object)gccBinary);
        if (output == null) {
            return new BrokenResult(String.format("Could not determine GCC version: failed to execute %s -v.", gccBinary.getName()));
        }
        return this.transform(output, gccBinary);
    }

    private GccVersionResult transform(String output, File gccBinary) {
        BufferedReader reader = new BufferedReader(new StringReader(output));
        HashMap<String, String> defines = new HashMap<String, String>();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                Matcher matcher = DEFINE_PATTERN.matcher(line);
                if (!matcher.matches()) {
                    return new BrokenResult(String.format("Could not determine GCC version: %s produced unexpected output.", gccBinary.getName()));
                }
                defines.put(matcher.group(1), matcher.group(2));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
        if (!defines.containsKey("__GNUC__")) {
            return new BrokenResult(String.format("Could not determine GCC version: %s produced unexpected output.", gccBinary.getName()));
        }
        if (defines.containsKey("__clang__")) {
            return new BrokenResult(String.format("XCode %s is a wrapper around Clang. Treating it as Clang and not GCC.", gccBinary.getName()));
        }
        return new DefaultGccVersionResult((String)defines.get("__GNUC__"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BrokenResult
    implements GccVersionResult {
        private final String message;

        private BrokenResult(String message) {
            this.message = message;
        }

        @Override
        public String getVersion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isAvailable() {
            return false;
        }

        @Override
        public void explain(TreeVisitor<? super String> visitor) {
            visitor.node((Object)this.message);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class GccVersionOutputProducer
    implements Transformer<String, File> {
        private final ExecActionFactory execActionFactory;

        GccVersionOutputProducer(ExecActionFactory execActionFactory) {
            this.execActionFactory = execActionFactory;
        }

        public String transform(File gccBinary) {
            ExecAction exec = this.execActionFactory.newExecAction();
            exec.executable((Object)gccBinary.getAbsolutePath());
            exec.setWorkingDir((Object)gccBinary.getParentFile());
            exec.args(new Object[]{"-dM", "-E", "-"});
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            exec.setStandardOutput((OutputStream)baos);
            exec.setIgnoreExitValue(true);
            ExecResult result = exec.execute();
            int exitValue = result.getExitValue();
            if (exitValue == 0) {
                return new String(baos.toByteArray());
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultGccVersionResult
    implements GccVersionResult {
        private final String scrapedVersion;

        public DefaultGccVersionResult(String scrapedVersion) {
            this.scrapedVersion = scrapedVersion;
        }

        @Override
        public String getVersion() {
            return this.scrapedVersion;
        }

        @Override
        public boolean isAvailable() {
            return true;
        }

        @Override
        public void explain(TreeVisitor<? super String> visitor) {
        }
    }
}

