/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.toolchain.internal.gcc;

import java.io.File;
import org.gradle.api.Transformer;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.nativebinaries.toolchain.Gcc;
import org.gradle.nativebinaries.toolchain.TargetedPlatformToolChain;
import org.gradle.nativebinaries.toolchain.internal.ToolChainAvailability;
import org.gradle.nativebinaries.toolchain.internal.ToolType;
import org.gradle.nativebinaries.toolchain.internal.gcc.AbstractGccCompatibleToolChain;
import org.gradle.nativebinaries.toolchain.internal.gcc.CommandLineToolSearchResult;
import org.gradle.nativebinaries.toolchain.internal.gcc.GccToolSearchPath;
import org.gradle.nativebinaries.toolchain.internal.gcc.version.GccVersionDeterminer;
import org.gradle.nativebinaries.toolchain.internal.gcc.version.GccVersionResult;
import org.gradle.nativebinaries.toolchain.internal.tools.DefaultGccCommandLineToolConfiguration;
import org.gradle.nativebinaries.toolchain.internal.tools.GccCommandLineToolConfigurationInternal;
import org.gradle.process.internal.ExecActionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GccToolChain
extends AbstractGccCompatibleToolChain
implements Gcc {
    private static final Logger LOGGER = LoggerFactory.getLogger(GccToolChain.class);
    public static final String DEFAULT_NAME = "gcc";
    private final Transformer<GccVersionResult, File> versionDeterminer;
    private GccVersionResult versionResult;

    public GccToolChain(Instantiator instantiator, String name, OperatingSystem operatingSystem, FileResolver fileResolver, ExecActionFactory execActionFactory) {
        super(name, operatingSystem, fileResolver, execActionFactory, new GccToolSearchPath(operatingSystem), instantiator);
        this.versionDeterminer = new GccVersionDeterminer(execActionFactory);
        this.add(instantiator.newInstance(DefaultGccCommandLineToolConfiguration.class, new Object[]{"cCompiler", ToolType.C_COMPILER, DEFAULT_NAME}));
        this.add(instantiator.newInstance(DefaultGccCommandLineToolConfiguration.class, new Object[]{"cppCompiler", ToolType.CPP_COMPILER, "g++"}));
        this.add(instantiator.newInstance(DefaultGccCommandLineToolConfiguration.class, new Object[]{"linker", ToolType.LINKER, "g++"}));
        this.add(instantiator.newInstance(DefaultGccCommandLineToolConfiguration.class, new Object[]{"staticLibArchiver", ToolType.STATIC_LIB_ARCHIVER, "ar"}));
        this.add(instantiator.newInstance(DefaultGccCommandLineToolConfiguration.class, new Object[]{"objcppCompiler", ToolType.OBJECTIVECPP_COMPILER, "g++"}));
        this.add(instantiator.newInstance(DefaultGccCommandLineToolConfiguration.class, new Object[]{"objcCompiler", ToolType.OBJECTIVEC_COMPILER, DEFAULT_NAME}));
        this.add(instantiator.newInstance(DefaultGccCommandLineToolConfiguration.class, new Object[]{"assembler", ToolType.ASSEMBLER, "as"}));
    }

    protected String getTypeName() {
        return "GNU GCC";
    }

    protected void initTools(TargetedPlatformToolChain targetedPlatformToolChain, ToolChainAvailability availability) {
        if (this.versionResult == null) {
            CommandLineToolSearchResult compiler = this.locate((GccCommandLineToolConfigurationInternal)targetedPlatformToolChain.getByName("cCompiler"));
            if (!compiler.isAvailable()) {
                compiler = this.locate((GccCommandLineToolConfigurationInternal)targetedPlatformToolChain.getByName("cppCompiler"));
            }
            availability.mustBeAvailable(compiler);
            if (!compiler.isAvailable()) {
                return;
            }
            this.versionResult = (GccVersionResult)this.versionDeterminer.transform((Object)compiler.getTool());
            LOGGER.debug("Found {} with version {}", (Object)ToolType.C_COMPILER.getToolName(), (Object)this.versionResult);
        }
        availability.mustBeAvailable(this.versionResult);
    }

    protected boolean canUseCommandFile() {
        int majorVersion;
        String[] components = this.versionResult.getVersion().split("\\.");
        try {
            majorVersion = Integer.valueOf(components[0]);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException(String.format("Unable to determine major g++ version from version number %s.", this.versionResult), e);
        }
        return majorVersion >= 4;
    }
}

