/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.toolchain.internal.gcc;

import org.gradle.api.internal.tasks.compile.Compiler;
import org.gradle.nativebinaries.internal.LinkerSpec;
import org.gradle.nativebinaries.internal.StaticLibraryArchiverSpec;
import org.gradle.nativebinaries.language.assembler.internal.AssembleSpec;
import org.gradle.nativebinaries.language.c.internal.CCompileSpec;
import org.gradle.nativebinaries.language.cpp.internal.CppCompileSpec;
import org.gradle.nativebinaries.language.objectivec.internal.ObjectiveCCompileSpec;
import org.gradle.nativebinaries.language.objectivecpp.internal.ObjectiveCppCompileSpec;
import org.gradle.nativebinaries.language.rc.internal.WindowsResourceCompileSpec;
import org.gradle.nativebinaries.toolchain.internal.CommandLineTool;
import org.gradle.nativebinaries.toolchain.internal.CommandLineToolInvocation;
import org.gradle.nativebinaries.toolchain.internal.DefaultCommandLineToolInvocation;
import org.gradle.nativebinaries.toolchain.internal.OutputCleaningCompiler;
import org.gradle.nativebinaries.toolchain.internal.PlatformToolChain;
import org.gradle.nativebinaries.toolchain.internal.ToolType;
import org.gradle.nativebinaries.toolchain.internal.gcc.ArStaticLibraryArchiver;
import org.gradle.nativebinaries.toolchain.internal.gcc.Assembler;
import org.gradle.nativebinaries.toolchain.internal.gcc.CCompiler;
import org.gradle.nativebinaries.toolchain.internal.gcc.CppCompiler;
import org.gradle.nativebinaries.toolchain.internal.gcc.GccLinker;
import org.gradle.nativebinaries.toolchain.internal.gcc.ObjectiveCCompiler;
import org.gradle.nativebinaries.toolchain.internal.gcc.ObjectiveCppCompiler;
import org.gradle.nativebinaries.toolchain.internal.tools.GccCommandLineToolConfigurationInternal;
import org.gradle.nativebinaries.toolchain.internal.tools.ToolRegistry;
import org.gradle.nativebinaries.toolchain.internal.tools.ToolSearchPath;
import org.gradle.process.internal.ExecActionFactory;
import org.gradle.util.TreeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GccPlatformToolChain
implements PlatformToolChain {
    private final ToolSearchPath toolSearchPath;
    private final ToolRegistry toolRegistry;
    private final ExecActionFactory execActionFactory;
    private final boolean useCommandFile;
    private final String outputFileSuffix;

    GccPlatformToolChain(ToolSearchPath toolSearchPath, ToolRegistry toolRegistry, ExecActionFactory execActionFactory, String outputFileSuffix, boolean useCommandFile) {
        this.toolRegistry = toolRegistry;
        this.toolSearchPath = toolSearchPath;
        this.execActionFactory = execActionFactory;
        this.useCommandFile = useCommandFile;
        this.outputFileSuffix = outputFileSuffix;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public void explain(TreeVisitor<? super String> visitor) {
    }

    @Override
    public Compiler<CppCompileSpec> createCppCompiler() {
        GccCommandLineToolConfigurationInternal cppCompilerTool = this.toolRegistry.getTool(ToolType.CPP_COMPILER);
        CppCompiler cppCompiler = new CppCompiler(this.commandLineTool(cppCompilerTool), this.commandLineToolInvocation(cppCompilerTool), this.outputFileSuffix, this.useCommandFile);
        return new OutputCleaningCompiler<CppCompileSpec>(cppCompiler, this.outputFileSuffix);
    }

    @Override
    public Compiler<CCompileSpec> createCCompiler() {
        GccCommandLineToolConfigurationInternal cCompilerTool = this.toolRegistry.getTool(ToolType.C_COMPILER);
        CCompiler cCompiler = new CCompiler(this.commandLineTool(cCompilerTool), this.commandLineToolInvocation(cCompilerTool), this.outputFileSuffix, this.useCommandFile);
        return new OutputCleaningCompiler<CCompileSpec>(cCompiler, this.outputFileSuffix);
    }

    @Override
    public Compiler<ObjectiveCppCompileSpec> createObjectiveCppCompiler() {
        GccCommandLineToolConfigurationInternal objectiveCppCompilerTool = this.toolRegistry.getTool(ToolType.OBJECTIVECPP_COMPILER);
        ObjectiveCppCompiler objectiveCppCompiler = new ObjectiveCppCompiler(this.commandLineTool(objectiveCppCompilerTool), this.commandLineToolInvocation(objectiveCppCompilerTool), this.outputFileSuffix, this.useCommandFile);
        return new OutputCleaningCompiler<ObjectiveCppCompileSpec>(objectiveCppCompiler, this.outputFileSuffix);
    }

    @Override
    public Compiler<ObjectiveCCompileSpec> createObjectiveCCompiler() {
        GccCommandLineToolConfigurationInternal objectiveCCompilerTool = this.toolRegistry.getTool(ToolType.OBJECTIVEC_COMPILER);
        ObjectiveCCompiler objectiveCCompiler = new ObjectiveCCompiler(this.commandLineTool(objectiveCCompilerTool), this.commandLineToolInvocation(objectiveCCompilerTool), this.outputFileSuffix, this.useCommandFile);
        return new OutputCleaningCompiler<ObjectiveCCompileSpec>(objectiveCCompiler, this.outputFileSuffix);
    }

    @Override
    public Compiler<AssembleSpec> createAssembler() {
        GccCommandLineToolConfigurationInternal assemblerTool = this.toolRegistry.getTool(ToolType.ASSEMBLER);
        return new Assembler(this.commandLineTool(assemblerTool), this.commandLineToolInvocation(assemblerTool), this.outputFileSuffix);
    }

    @Override
    public Compiler<WindowsResourceCompileSpec> createWindowsResourceCompiler() {
        throw new RuntimeException("Windows resource compiler is not available");
    }

    @Override
    public Compiler<LinkerSpec> createLinker() {
        GccCommandLineToolConfigurationInternal linkerTool = this.toolRegistry.getTool(ToolType.LINKER);
        return new GccLinker(this.commandLineTool(linkerTool), this.commandLineToolInvocation(linkerTool), this.useCommandFile);
    }

    @Override
    public Compiler<StaticLibraryArchiverSpec> createStaticLibraryArchiver() {
        GccCommandLineToolConfigurationInternal staticLibArchiverTool = this.toolRegistry.getTool(ToolType.STATIC_LIB_ARCHIVER);
        return new ArStaticLibraryArchiver(this.commandLineTool(staticLibArchiverTool), this.commandLineToolInvocation(staticLibArchiverTool));
    }

    private CommandLineTool commandLineTool(GccCommandLineToolConfigurationInternal tool) {
        ToolType key = tool.getToolType();
        String exeName = tool.getExecutable();
        return new CommandLineTool(key.getToolName(), this.toolSearchPath.locate(key, exeName).getTool(), this.execActionFactory);
    }

    private CommandLineToolInvocation commandLineToolInvocation(GccCommandLineToolConfigurationInternal toolConfiguration) {
        DefaultCommandLineToolInvocation baseInvocation = new DefaultCommandLineToolInvocation();
        baseInvocation.addPath(this.toolSearchPath.getPath());
        baseInvocation.addEnvironmentVar("CYGWIN", "nodosfilewarning");
        baseInvocation.addPostArgsAction(toolConfiguration.getArgAction());
        return baseInvocation;
    }
}

