/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.toolchain.internal.gcc;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.internal.tasks.SimpleWorkResult;
import org.gradle.api.internal.tasks.compile.Compiler;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.nativebinaries.internal.LinkerSpec;
import org.gradle.nativebinaries.internal.SharedLibraryLinkerSpec;
import org.gradle.nativebinaries.toolchain.internal.ArgsTransformer;
import org.gradle.nativebinaries.toolchain.internal.CommandLineTool;
import org.gradle.nativebinaries.toolchain.internal.CommandLineToolInvocation;
import org.gradle.nativebinaries.toolchain.internal.MutableCommandLineToolInvocation;
import org.gradle.nativebinaries.toolchain.internal.gcc.GccOptionsFileArgTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GccLinker
implements Compiler<LinkerSpec> {
    private final CommandLineTool commandLineTool;
    private final ArgsTransformer<LinkerSpec> argsTransformer = new GccLinkerArgsTransformer();
    private final CommandLineToolInvocation baseInvocation;
    private final boolean useCommandFile;

    public GccLinker(CommandLineTool commandLineTool, CommandLineToolInvocation baseInvocation, boolean useCommandFile) {
        this.baseInvocation = baseInvocation;
        this.useCommandFile = useCommandFile;
        this.commandLineTool = commandLineTool;
    }

    public WorkResult execute(LinkerSpec spec) {
        MutableCommandLineToolInvocation invocation = this.baseInvocation.copy();
        if (this.useCommandFile) {
            invocation.addPostArgsAction(new GccOptionsFileArgTransformer(spec.getTempDir()));
        }
        invocation.setArgs((List)this.argsTransformer.transform(spec));
        this.commandLineTool.execute(invocation);
        return new SimpleWorkResult(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GccLinkerArgsTransformer
    implements ArgsTransformer<LinkerSpec> {
        private GccLinkerArgsTransformer() {
        }

        public List<String> transform(LinkerSpec spec) {
            ArrayList<String> args = new ArrayList<String>();
            args.addAll(spec.getSystemArgs());
            if (spec instanceof SharedLibraryLinkerSpec) {
                args.add("-shared");
                this.maybeSetInstallName((SharedLibraryLinkerSpec)spec, args);
            }
            args.add("-o");
            args.add(spec.getOutputFile().getAbsolutePath());
            for (File file : spec.getObjectFiles()) {
                args.add(file.getAbsolutePath());
            }
            for (File file : spec.getLibraries()) {
                args.add(file.getAbsolutePath());
            }
            if (!spec.getLibraryPath().isEmpty()) {
                throw new UnsupportedOperationException("Library Path not yet supported on GCC");
            }
            for (String userArg : spec.getArgs()) {
                args.add(userArg);
            }
            return args;
        }

        private void maybeSetInstallName(SharedLibraryLinkerSpec spec, List<String> args) {
            String installName = spec.getInstallName();
            if (installName == null || OperatingSystem.current().isWindows()) {
                return;
            }
            if (OperatingSystem.current().isMacOsX()) {
                args.add("-Wl,-install_name," + installName);
            } else {
                args.add("-Wl,-soname," + installName);
            }
        }
    }
}

