/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.toolchain.internal.gcc;

import java.util.List;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.internal.DefaultNamedDomainObjectSet;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.nativebinaries.toolchain.GccCommandLineToolConfiguration;
import org.gradle.nativebinaries.toolchain.TargetedPlatformToolChain;
import org.gradle.nativebinaries.toolchain.internal.tools.DefaultGccCommandLineToolConfiguration;
import org.gradle.nativebinaries.toolchain.internal.tools.GccCommandLineToolConfigurationInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGccPlatformToolChain<T extends GccCommandLineToolConfiguration>
extends DefaultNamedDomainObjectSet<T>
implements TargetedPlatformToolChain<T> {
    private final String name;
    private final String displayName;

    public DefaultGccPlatformToolChain(Class<? extends T> type, Map<String, T> asMap, Instantiator instantiator, String name, String displayName) {
        super(type, instantiator);
        this.name = name;
        this.displayName = displayName;
        for (GccCommandLineToolConfiguration tool : asMap.values()) {
            this.add(this.newConfiguredGccTool(tool));
        }
    }

    private T newConfiguredGccTool(T defaultTool) {
        GccCommandLineToolConfigurationInternal gccToolInternal = (GccCommandLineToolConfigurationInternal)defaultTool;
        DefaultGccCommandLineToolConfiguration platformTool = (DefaultGccCommandLineToolConfiguration)this.getInstantiator().newInstance(DefaultGccCommandLineToolConfiguration.class, new Object[]{defaultTool.getName(), gccToolInternal.getToolType(), defaultTool.getExecutable()});
        Action<List<String>> argAction = gccToolInternal.getArgAction();
        platformTool.withArguments(argAction);
        return (T)platformTool;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getName() {
        return this.name;
    }
}

