/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.toolchain.internal;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.internal.DefaultPolymorphicDomainObjectContainer;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.nativebinaries.platform.Platform;
import org.gradle.nativebinaries.toolchain.ToolChain;
import org.gradle.nativebinaries.toolchain.internal.PlatformToolChain;
import org.gradle.nativebinaries.toolchain.internal.ToolChainInternal;
import org.gradle.nativebinaries.toolchain.internal.ToolChainRegistryInternal;
import org.gradle.nativebinaries.toolchain.internal.ToolSearchResult;
import org.gradle.nativebinaries.toolchain.internal.UnavailablePlatformToolChain;
import org.gradle.util.TreeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultToolChainRegistry
extends DefaultPolymorphicDomainObjectContainer<ToolChain>
implements ToolChainRegistryInternal {
    private final Map<String, Class<? extends ToolChain>> registeredDefaults = new LinkedHashMap<String, Class<? extends ToolChain>>();
    private final List<ToolChainInternal> searchOrder = new ArrayList<ToolChainInternal>();

    public DefaultToolChainRegistry(Instantiator instantiator) {
        super(ToolChain.class, instantiator);
        this.whenObjectAdded((Action)new Action<ToolChain>(){

            public void execute(ToolChain toolChain) {
                DefaultToolChainRegistry.this.searchOrder.add((ToolChainInternal)toolChain);
            }
        });
        this.whenObjectRemoved((Action)new Action<ToolChain>(){

            public void execute(ToolChain toolChain) {
                DefaultToolChainRegistry.this.searchOrder.remove(toolChain);
            }
        });
    }

    protected void handleAttemptToAddItemWithNonUniqueName(ToolChain toolChain) {
        throw new InvalidUserDataException(String.format("ToolChain with name '%s' added multiple times", toolChain.getName()));
    }

    @Override
    public void registerDefaultToolChain(String name, Class<? extends ToolChain> type) {
        this.registeredDefaults.put(name, type);
    }

    @Override
    public void addDefaultToolChains() {
        for (String name : this.registeredDefaults.keySet()) {
            this.create(name, this.registeredDefaults.get(name));
        }
    }

    @Override
    public ToolChain getForPlatform(Platform targetPlatform) {
        for (ToolChainInternal toolChain : this.searchOrder) {
            if (!toolChain.select(targetPlatform).isAvailable()) continue;
            return toolChain;
        }
        LinkedHashMap<String, PlatformToolChain> candidates = new LinkedHashMap<String, PlatformToolChain>();
        for (ToolChainInternal toolChain : this.searchOrder) {
            candidates.put(toolChain.getDisplayName(), toolChain.select(targetPlatform));
        }
        return new UnavailableToolChain(new UnavailableToolChainDescription(targetPlatform, candidates));
    }

    private static class UnavailableToolChain
    implements ToolChainInternal {
        private final OperatingSystem operatingSystem = OperatingSystem.current();
        private final ToolSearchResult failure;

        UnavailableToolChain(ToolSearchResult failure) {
            this.failure = failure;
        }

        public String getDisplayName() {
            return this.getName();
        }

        public String getName() {
            return "unavailable";
        }

        public PlatformToolChain select(Platform targetPlatform) {
            return new UnavailablePlatformToolChain(this.failure);
        }

        public String getExecutableName(String executablePath) {
            return this.operatingSystem.getExecutableName(executablePath);
        }

        public String getSharedLibraryName(String libraryName) {
            return this.operatingSystem.getSharedLibraryName(libraryName);
        }

        public String getSharedLibraryLinkFileName(String libraryName) {
            return this.getSharedLibraryName(libraryName);
        }

        public String getStaticLibraryName(String libraryName) {
            return this.operatingSystem.getStaticLibraryName(libraryName);
        }

        public String getOutputType() {
            return "unavailable";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnavailableToolChainDescription
    implements ToolSearchResult {
        private final Platform targetPlatform;
        private final Map<String, PlatformToolChain> candidates;

        private UnavailableToolChainDescription(Platform targetPlatform, Map<String, PlatformToolChain> candidates) {
            this.targetPlatform = targetPlatform;
            this.candidates = candidates;
        }

        @Override
        public boolean isAvailable() {
            return false;
        }

        @Override
        public void explain(TreeVisitor<? super String> visitor) {
            visitor.node((Object)String.format("No tool chain is available to build for platform '%s'", this.targetPlatform.getName()));
            visitor.startChildren();
            for (Map.Entry<String, PlatformToolChain> entry : this.candidates.entrySet()) {
                visitor.node((Object)entry.getKey());
                visitor.startChildren();
                entry.getValue().explain(visitor);
                visitor.endChildren();
            }
            if (this.candidates.isEmpty()) {
                visitor.node((Object)"No tool chain plugin applied.");
            }
            visitor.endChildren();
        }
    }
}

