/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.test.cunit.internal;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.nativebinaries.ProjectNativeBinary;
import org.gradle.nativebinaries.internal.ProjectNativeBinaryInternal;
import org.gradle.nativebinaries.internal.resolve.NativeDependencyResolver;
import org.gradle.nativebinaries.language.internal.DefaultPreprocessingTool;
import org.gradle.nativebinaries.test.NativeTestSuiteBinary;
import org.gradle.nativebinaries.test.cunit.CUnitTestSuite;
import org.gradle.nativebinaries.test.internal.DefaultNativeTestSuiteBinary;
import org.gradle.nativebinaries.toolchain.internal.ToolChainInternal;
import org.gradle.runtime.base.BinaryContainer;
import org.gradle.runtime.base.internal.BinaryNamingScheme;
import org.gradle.runtime.base.internal.DefaultBinaryNamingSchemeBuilder;

public class CreateCUnitBinaries {
    private final ProjectInternal project;
    private final Instantiator instantiator;
    private final NativeDependencyResolver resolver;

    public CreateCUnitBinaries(ProjectInternal project, Instantiator instantiator, NativeDependencyResolver resolver) {
        this.project = project;
        this.instantiator = instantiator;
        this.resolver = resolver;
    }

    public void apply(final CUnitTestSuite cUnitTestSuite, final BinaryContainer binaries) {
        cUnitTestSuite.getTestedComponent().getBinaries().withType(ProjectNativeBinaryInternal.class).all((Action)new Action<ProjectNativeBinaryInternal>(){

            public void execute(ProjectNativeBinaryInternal testedBinary) {
                final ProjectNativeBinary cunitExe = CreateCUnitBinaries.this.createTestBinary(cUnitTestSuite, testedBinary, CreateCUnitBinaries.this.project);
                ((ExtensionAware)cunitExe).getExtensions().create("cCompiler", DefaultPreprocessingTool.class, new Object[0]);
                cUnitTestSuite.getBinaries().add((Object)cunitExe);
                binaries.add((Object)cunitExe);
                testedBinary.getSource().all((Action)new Action<LanguageSourceSet>(){

                    public void execute(LanguageSourceSet languageSourceSet) {
                        cunitExe.source(languageSourceSet);
                    }
                });
            }
        });
    }

    public ProjectNativeBinary createTestBinary(CUnitTestSuite cUnitTestSuite, ProjectNativeBinaryInternal testedBinary, ProjectInternal project) {
        BinaryNamingScheme namingScheme = new DefaultBinaryNamingSchemeBuilder(testedBinary.getNamingScheme()).withComponentName(cUnitTestSuite.getBaseName()).withTypeString("CUnitExe").build();
        ProjectNativeBinary testBinary = (ProjectNativeBinary)this.instantiator.newInstance(DefaultNativeTestSuiteBinary.class, new Object[]{cUnitTestSuite, testedBinary.getFlavor(), testedBinary.getToolChain(), testedBinary.getTargetPlatform(), testedBinary.getBuildType(), namingScheme, this.resolver});
        this.setupDefaults(testBinary, project);
        return testBinary;
    }

    private void setupDefaults(ProjectNativeBinary nativeBinary, ProjectInternal project) {
        BinaryNamingScheme namingScheme = ((ProjectNativeBinaryInternal)nativeBinary).getNamingScheme();
        File binaryOutputDir = new File(new File(project.getBuildDir(), "binaries"), namingScheme.getOutputDirectoryBase());
        String baseName = nativeBinary.getComponent().getBaseName();
        ToolChainInternal tc = (ToolChainInternal)nativeBinary.getToolChain();
        ((NativeTestSuiteBinary)((Object)nativeBinary)).setExecutableFile(new File(binaryOutputDir, tc.getExecutableName(baseName)));
    }
}

