/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.test.cunit.internal;

import java.io.File;
import org.gradle.api.Task;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.language.base.FunctionalSourceSet;
import org.gradle.language.base.ProjectSourceSet;
import org.gradle.language.c.CSourceSet;
import org.gradle.nativebinaries.ProjectNativeComponent;
import org.gradle.nativebinaries.test.cunit.CUnitTestSuite;
import org.gradle.nativebinaries.test.cunit.tasks.GenerateCUnitLauncher;

public class ConfigureCUnitTestSources {
    private final ProjectInternal project;

    public ConfigureCUnitTestSources(ProjectInternal project) {
        this.project = project;
    }

    public void apply(CUnitTestSuite cUnitTestSuite) {
        FunctionalSourceSet suiteSourceSet = this.createSuiteSources(cUnitTestSuite);
        CSourceSet launcherSources = (CSourceSet)suiteSourceSet.maybeCreate("cunitLauncher", CSourceSet.class);
        cUnitTestSuite.source(launcherSources);
        this.createCUnitLauncherTask(cUnitTestSuite, launcherSources);
        CSourceSet testSources = (CSourceSet)suiteSourceSet.maybeCreate("cunit", CSourceSet.class);
        cUnitTestSuite.source(testSources);
        testSources.lib(launcherSources);
        ProjectNativeComponent testedComponent = cUnitTestSuite.getTestedComponent();
        cUnitTestSuite.source(testedComponent.getSource());
        testSources.lib(testedComponent.getSource().withType(CSourceSet.class));
    }

    private FunctionalSourceSet createSuiteSources(CUnitTestSuite cUnitTestSuite) {
        ProjectSourceSet projectSourceSet = (ProjectSourceSet)this.project.getExtensions().getByType(ProjectSourceSet.class);
        return (FunctionalSourceSet)projectSourceSet.maybeCreate(cUnitTestSuite.getName());
    }

    private void createCUnitLauncherTask(CUnitTestSuite suite, CSourceSet cunitSourceSet) {
        String taskName = suite.getName() + "CUnitLauncher";
        GenerateCUnitLauncher skeletonTask = (GenerateCUnitLauncher)this.project.getTasks().create(taskName, GenerateCUnitLauncher.class);
        File baseDir = new File(this.project.getBuildDir(), "src/" + taskName);
        skeletonTask.setSourceDir(new File(baseDir, "cunit"));
        skeletonTask.setHeaderDir(new File(baseDir, "headers"));
        cunitSourceSet.generatedBy((Task)skeletonTask);
    }
}

