/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.plugins;

import java.util.Arrays;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.configuration.project.ProjectConfigurationActionContainer;
import org.gradle.internal.Actions;
import org.gradle.internal.Factory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.language.base.plugins.LanguageBasePlugin;
import org.gradle.model.ModelFinalizer;
import org.gradle.model.ModelRule;
import org.gradle.model.ModelRules;
import org.gradle.model.internal.ModelCreator;
import org.gradle.nativebinaries.BuildTypeContainer;
import org.gradle.nativebinaries.FlavorContainer;
import org.gradle.nativebinaries.NativeExecutable;
import org.gradle.nativebinaries.NativeLibrary;
import org.gradle.nativebinaries.ProjectNativeComponent;
import org.gradle.nativebinaries.internal.DefaultBuildTypeContainer;
import org.gradle.nativebinaries.internal.DefaultFlavorContainer;
import org.gradle.nativebinaries.internal.NativeExecutableFactory;
import org.gradle.nativebinaries.internal.NativeLibraryFactory;
import org.gradle.nativebinaries.internal.configure.ApplySourceSetConventions;
import org.gradle.nativebinaries.internal.configure.ConfigureGeneratedSourceSets;
import org.gradle.nativebinaries.internal.configure.CreateDefaultBuildTypes;
import org.gradle.nativebinaries.internal.configure.CreateDefaultFlavors;
import org.gradle.nativebinaries.internal.configure.CreateDefaultPlatform;
import org.gradle.nativebinaries.internal.configure.CreateNativeBinaries;
import org.gradle.nativebinaries.internal.configure.DefaultNativeComponentExtension;
import org.gradle.nativebinaries.internal.configure.RepositoriesFactory;
import org.gradle.nativebinaries.internal.resolve.NativeDependencyResolver;
import org.gradle.nativebinaries.platform.PlatformContainer;
import org.gradle.nativebinaries.platform.internal.DefaultPlatformContainer;
import org.gradle.nativebinaries.toolchain.internal.DefaultToolChainRegistry;
import org.gradle.nativebinaries.toolchain.internal.ToolChainRegistryInternal;
import org.gradle.runtime.base.ProjectComponentContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class NativeComponentModelPlugin
implements Plugin<ProjectInternal> {
    private final Instantiator instantiator;
    private final ProjectConfigurationActionContainer configurationActions;
    private final ModelRules modelRules;
    private final NativeDependencyResolver resolver;
    private final FileResolver fileResolver;

    @Inject
    public NativeComponentModelPlugin(Instantiator instantiator, ProjectConfigurationActionContainer configurationActions, ModelRules modelRules, NativeDependencyResolver resolver, FileResolver fileResolver) {
        this.instantiator = instantiator;
        this.configurationActions = configurationActions;
        this.modelRules = modelRules;
        this.resolver = resolver;
        this.fileResolver = fileResolver;
    }

    public void apply(ProjectInternal project) {
        project.getPlugins().apply(BasePlugin.class);
        project.getPlugins().apply(LanguageBasePlugin.class);
        this.modelRules.register("toolChains", ToolChainRegistryInternal.class, this.factory(DefaultToolChainRegistry.class));
        this.modelRules.register("platforms", PlatformContainer.class, this.factory(DefaultPlatformContainer.class));
        this.modelRules.register("buildTypes", BuildTypeContainer.class, this.factory(DefaultBuildTypeContainer.class));
        this.modelRules.register("flavors", FlavorContainer.class, this.factory(DefaultFlavorContainer.class));
        project.getModelRegistry().create("repositories", Arrays.asList("flavors", "platforms", "buildTypes"), (ModelCreator)new RepositoriesFactory(this.instantiator, this.fileResolver));
        this.modelRules.rule((ModelRule)new CreateDefaultPlatform());
        this.modelRules.rule((ModelRule)new CreateDefaultBuildTypes());
        this.modelRules.rule((ModelRule)new CreateDefaultFlavors());
        this.modelRules.rule((ModelRule)new AddDefaultToolChainsIfRequired());
        this.modelRules.rule((ModelRule)new CreateNativeBinaries(this.instantiator, project, this.resolver));
        ProjectComponentContainer components = (ProjectComponentContainer)project.getExtensions().getByType(ProjectComponentContainer.class);
        components.registerFactory(NativeExecutable.class, (NamedDomainObjectFactory)new NativeExecutableFactory(this.instantiator, (Project)project));
        NamedDomainObjectContainer nativeExecutables = components.containerWithType(NativeExecutable.class);
        components.registerFactory(NativeLibrary.class, (NamedDomainObjectFactory)new NativeLibraryFactory(this.instantiator, (Project)project));
        NamedDomainObjectContainer nativeLibraries = components.containerWithType(NativeLibrary.class);
        project.getExtensions().create("nativeCode", DefaultNativeComponentExtension.class, new Object[]{nativeExecutables, nativeLibraries});
        project.getExtensions().add("nativeComponents", (Object)components.withType(ProjectNativeComponent.class));
        project.getExtensions().add("executables", (Object)nativeExecutables);
        project.getExtensions().add("libraries", (Object)nativeLibraries);
        this.configurationActions.add(Actions.composite((Action[])new Action[]{new ConfigureGeneratedSourceSets(), new ApplySourceSetConventions()}));
    }

    private <T> Factory<T> factory(Class<T> type) {
        return new InstantiatingFactory<T>(type, this.instantiator);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InstantiatingFactory<T>
    implements Factory<T> {
        private final Class<T> type;
        private final Instantiator instantiator;

        public InstantiatingFactory(Class<T> type, Instantiator instantiator) {
            this.type = type;
            this.instantiator = instantiator;
        }

        public T create() {
            return (T)this.instantiator.newInstance(this.type, new Object[]{this.instantiator});
        }
    }

    private static class AddDefaultToolChainsIfRequired
    extends ModelFinalizer {
        private AddDefaultToolChainsIfRequired() {
        }

        void createDefaultToolChain(ToolChainRegistryInternal toolChains) {
            if (toolChains.isEmpty()) {
                toolChains.addDefaultToolChains();
            }
        }
    }
}

