/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.platform.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;
import org.gradle.internal.typeconversion.TypeConversionException;
import org.gradle.nativebinaries.platform.OperatingSystem;
import org.gradle.nativebinaries.platform.internal.DefaultOperatingSystem;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperatingSystemNotationParser {
    private static final List<String> WINDOWS_ALIASES = Arrays.asList("windows");
    private static final List<String> OSX_ALIASES = Arrays.asList("osx", "mac os x");
    private static final List<String> LINUX_ALIASES = Arrays.asList("linux");
    private static final List<String> SOLARIS_ALIASES = Arrays.asList("solaris", "sunos");
    private static final List<String> FREEBSD_ALIASES = Arrays.asList("freebsd");

    public static NotationParser<Object, OperatingSystem> parser() {
        return NotationParserBuilder.toType(OperatingSystem.class).fromCharSequence((NotationConverter)new Parser()).toComposite();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Parser
    implements NotationConverter<String, OperatingSystem> {
        private Parser() {
        }

        public void convert(String notation, NotationConvertResult<? super OperatingSystem> result) throws TypeConversionException {
            OperatingSystem operatingSystem = this.parseType(notation);
            if (operatingSystem != null) {
                result.converted((Object)operatingSystem);
            }
        }

        protected OperatingSystem parseType(String notation) {
            if (WINDOWS_ALIASES.contains(notation.toLowerCase())) {
                return new DefaultOperatingSystem(notation, (org.gradle.internal.os.OperatingSystem)org.gradle.internal.os.OperatingSystem.WINDOWS);
            }
            if (OSX_ALIASES.contains(notation.toLowerCase())) {
                return new DefaultOperatingSystem(notation, (org.gradle.internal.os.OperatingSystem)org.gradle.internal.os.OperatingSystem.MAC_OS);
            }
            if (LINUX_ALIASES.contains(notation.toLowerCase())) {
                return new DefaultOperatingSystem(notation, (org.gradle.internal.os.OperatingSystem)org.gradle.internal.os.OperatingSystem.LINUX);
            }
            if (SOLARIS_ALIASES.contains(notation.toLowerCase())) {
                return new DefaultOperatingSystem(notation, (org.gradle.internal.os.OperatingSystem)org.gradle.internal.os.OperatingSystem.SOLARIS);
            }
            if (FREEBSD_ALIASES.contains(notation.toLowerCase())) {
                return new DefaultOperatingSystem(notation, (org.gradle.internal.os.OperatingSystem)org.gradle.internal.os.OperatingSystem.FREE_BSD);
            }
            return null;
        }

        public void describe(Collection<String> candidateFormats) {
            ArrayList allValues = new ArrayList();
            allValues.addAll(WINDOWS_ALIASES);
            allValues.addAll(OSX_ALIASES);
            allValues.addAll(LINUX_ALIASES);
            allValues.addAll(SOLARIS_ALIASES);
            candidateFormats.add("One of the following values: " + GUtil.toString(allValues));
        }
    }
}

