/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.platform.internal;

import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.nativebinaries.platform.Architecture;
import org.gradle.nativebinaries.platform.OperatingSystem;
import org.gradle.nativebinaries.platform.internal.ArchitectureInternal;
import org.gradle.nativebinaries.platform.internal.ArchitectureNotationParser;
import org.gradle.nativebinaries.platform.internal.DefaultOperatingSystem;
import org.gradle.nativebinaries.platform.internal.OperatingSystemNotationParser;
import org.gradle.nativebinaries.platform.internal.PlatformInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPlatform
implements PlatformInternal {
    private final NotationParser<Object, Architecture> archParser;
    private final NotationParser<Object, OperatingSystem> osParser;
    private final String name;
    private Architecture architecture;
    private OperatingSystem operatingSystem;

    public DefaultPlatform(String name, NotationParser<Object, Architecture> archParser, NotationParser<Object, OperatingSystem> osParser) {
        this.name = name;
        this.architecture = ArchitectureInternal.TOOL_CHAIN_DEFAULT;
        this.operatingSystem = DefaultOperatingSystem.TOOL_CHAIN_DEFAULT;
        this.archParser = archParser;
        this.osParser = osParser;
    }

    public DefaultPlatform(String name) {
        this(name, ArchitectureNotationParser.parser(), OperatingSystemNotationParser.parser());
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public String getDisplayName() {
        return String.format("platform '%s'", this.name);
    }

    @Override
    public Architecture getArchitecture() {
        return this.architecture;
    }

    @Override
    public void architecture(Object notation) {
        this.architecture = (Architecture)this.archParser.parseNotation(notation);
    }

    @Override
    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    @Override
    public void operatingSystem(Object notation) {
        this.operatingSystem = (OperatingSystem)this.osParser.parseNotation(notation);
    }

    @Override
    public String getCompatibilityString() {
        return String.format("%s:%s", this.architecture.getName(), this.operatingSystem.getName());
    }
}

