/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.language.c.internal.incremental;

import java.io.File;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.state.FileSnapshotter;
import org.gradle.api.internal.changedetection.state.TaskArtifactStateCacheAccess;
import org.gradle.api.internal.tasks.SimpleWorkResult;
import org.gradle.api.internal.tasks.compile.CompileSpec;
import org.gradle.api.internal.tasks.compile.Compiler;
import org.gradle.api.tasks.WorkResult;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.PersistentStateCache;
import org.gradle.internal.Factory;
import org.gradle.language.jvm.internal.SimpleStaleClassCleaner;
import org.gradle.messaging.serialize.Serializer;
import org.gradle.nativebinaries.language.c.internal.incremental.CompilationState;
import org.gradle.nativebinaries.language.c.internal.incremental.CompilationStateSerializer;
import org.gradle.nativebinaries.language.c.internal.incremental.DefaultSourceIncludesParser;
import org.gradle.nativebinaries.language.c.internal.incremental.DefaultSourceIncludesResolver;
import org.gradle.nativebinaries.language.c.internal.incremental.IncrementalCompilation;
import org.gradle.nativebinaries.language.c.internal.incremental.IncrementalCompileProcessor;
import org.gradle.nativebinaries.language.c.internal.incremental.SourceIncludesParser;
import org.gradle.nativebinaries.language.c.internal.incremental.sourceparser.CSourceParser;
import org.gradle.nativebinaries.language.c.internal.incremental.sourceparser.RegexBackedCSourceParser;
import org.gradle.nativebinaries.toolchain.Clang;
import org.gradle.nativebinaries.toolchain.Gcc;
import org.gradle.nativebinaries.toolchain.ToolChain;
import org.gradle.nativebinaries.toolchain.internal.NativeCompileSpec;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncrementalNativeCompiler
implements Compiler<NativeCompileSpec> {
    private final Compiler<NativeCompileSpec> delegateCompiler;
    private final boolean importsAreIncludes;
    private final TaskInternal task;
    private final TaskArtifactStateCacheAccess cacheAccess;
    private final FileSnapshotter fileSnapshotter;
    private final CSourceParser sourceParser = new RegexBackedCSourceParser();

    public IncrementalNativeCompiler(TaskInternal task, TaskArtifactStateCacheAccess cacheAccess, FileSnapshotter fileSnapshotter, Compiler<NativeCompileSpec> delegateCompiler, ToolChain toolChain) {
        this.task = task;
        this.cacheAccess = cacheAccess;
        this.fileSnapshotter = fileSnapshotter;
        this.delegateCompiler = delegateCompiler;
        this.importsAreIncludes = Clang.class.isAssignableFrom(toolChain.getClass()) || Gcc.class.isAssignableFrom(toolChain.getClass());
    }

    public WorkResult execute(final NativeCompileSpec spec) {
        IncrementalCompilation compilation = (IncrementalCompilation)this.cacheAccess.useCache("process source files", (Factory)new Factory<IncrementalCompilation>(){

            public IncrementalCompilation create() {
                DefaultSourceIncludesParser sourceIncludesParser = new DefaultSourceIncludesParser(IncrementalNativeCompiler.this.sourceParser, IncrementalNativeCompiler.this.importsAreIncludes);
                IncrementalCompileProcessor processor = IncrementalNativeCompiler.this.createProcessor(sourceIncludesParser, spec.getIncludeRoots());
                return processor.processSourceFiles(spec.getSourceFiles());
            }
        });
        if (spec.isIncrementalCompile()) {
            return this.doIncrementalCompile(compilation, spec);
        }
        return this.doCleanIncrementalCompile(spec);
    }

    protected WorkResult doIncrementalCompile(IncrementalCompilation compilation, NativeCompileSpec spec) {
        spec.setSourceFiles(compilation.getRecompile());
        spec.setRemovedSourceFiles(compilation.getRemoved());
        return this.delegateCompiler.execute((CompileSpec)spec);
    }

    protected WorkResult doCleanIncrementalCompile(NativeCompileSpec spec) {
        boolean deleted = this.cleanPreviousOutputs(spec);
        WorkResult compileResult = this.delegateCompiler.execute((CompileSpec)spec);
        if (deleted && !compileResult.getDidWork()) {
            return new SimpleWorkResult(deleted);
        }
        return compileResult;
    }

    private boolean cleanPreviousOutputs(NativeCompileSpec spec) {
        SimpleStaleClassCleaner cleaner = new SimpleStaleClassCleaner(this.getTask().getOutputs());
        cleaner.setDestinationDir(spec.getObjectFileDir());
        cleaner.execute();
        return cleaner.getDidWork();
    }

    protected TaskInternal getTask() {
        return this.task;
    }

    private IncrementalCompileProcessor createProcessor(SourceIncludesParser sourceIncludesParser, Iterable<File> includes) {
        PersistentStateCache<CompilationState> compileStateCache = this.createCompileStateCache(this.task.getPath());
        DefaultSourceIncludesResolver dependencyParser = new DefaultSourceIncludesResolver(CollectionUtils.toList(includes));
        return new IncrementalCompileProcessor(compileStateCache, dependencyParser, sourceIncludesParser, this.fileSnapshotter);
    }

    private PersistentStateCache<CompilationState> createCompileStateCache(final String taskPath) {
        final PersistentIndexedCache stateIndexedCache = this.cacheAccess.createCache("compilationState", String.class, (Serializer)new CompilationStateSerializer());
        return new PersistentStateCache<CompilationState>(){

            public CompilationState get() {
                return (CompilationState)stateIndexedCache.get((Object)taskPath);
            }

            public void set(CompilationState newValue) {
                stateIndexedCache.put((Object)taskPath, (Object)newValue);
            }

            public void update(PersistentStateCache.UpdateAction<CompilationState> updateAction) {
                throw new UnsupportedOperationException();
            }
        };
    }
}

