/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.language.c.internal.incremental;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.gradle.nativebinaries.language.c.internal.incremental.SourceIncludes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultSourceIncludes
implements SourceIncludes,
Serializable {
    private final List<String> quotedIncludes = new ArrayList<String>();
    private final List<String> systemIncludes = new ArrayList<String>();
    private final List<String> macroIncludes = new ArrayList<String>();

    DefaultSourceIncludes() {
    }

    public void addAll(List<String> includes) {
        for (String value : includes) {
            if (value.startsWith("<") && value.endsWith(">")) {
                this.systemIncludes.add(this.strip(value));
                continue;
            }
            if (value.startsWith("\"") && value.endsWith("\"")) {
                this.quotedIncludes.add(this.strip(value));
                continue;
            }
            this.macroIncludes.add(value);
        }
    }

    private String strip(String include) {
        return include.substring(1, include.length() - 1);
    }

    @Override
    public List<String> getQuotedIncludes() {
        return this.quotedIncludes;
    }

    @Override
    public List<String> getSystemIncludes() {
        return this.systemIncludes;
    }

    @Override
    public List<String> getMacroIncludes() {
        return this.macroIncludes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultSourceIncludes)) {
            return false;
        }
        DefaultSourceIncludes that = (DefaultSourceIncludes)o;
        return this.macroIncludes.equals(that.macroIncludes) && this.quotedIncludes.equals(that.quotedIncludes) && this.systemIncludes.equals(that.systemIncludes);
    }

    public int hashCode() {
        int result = this.quotedIncludes.hashCode();
        result = 31 * result + this.systemIncludes.hashCode();
        result = 31 * result + this.macroIncludes.hashCode();
        return result;
    }
}

