/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.internal.resolve;

import java.io.File;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.AbstractFileCollection;
import org.gradle.api.internal.file.collections.SimpleFileCollection;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.language.HeaderExportingSourceSet;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.nativebinaries.NativeDependencySet;
import org.gradle.nativebinaries.internal.resolve.NativeBinaryRequirementResolveResult;
import org.gradle.nativebinaries.internal.resolve.NativeBinaryResolveResult;
import org.gradle.nativebinaries.internal.resolve.NativeDependencyResolver;

public class SourceSetNativeDependencyResolver
implements NativeDependencyResolver {
    private final NativeDependencyResolver delegate;

    public SourceSetNativeDependencyResolver(NativeDependencyResolver delegate) {
        this.delegate = delegate;
    }

    public void resolve(NativeBinaryResolveResult nativeBinaryResolveResult) {
        for (NativeBinaryRequirementResolveResult resolution : nativeBinaryResolveResult.getPendingResolutions()) {
            if (!(resolution.getInput() instanceof LanguageSourceSet)) continue;
            LanguageSourceSet input = (LanguageSourceSet)resolution.getInput();
            resolution.setNativeDependencySet(this.createNativeDependencySet(input));
        }
        this.delegate.resolve(nativeBinaryResolveResult);
    }

    private NativeDependencySet createNativeDependencySet(LanguageSourceSet sourceSet) {
        if (sourceSet instanceof HeaderExportingSourceSet) {
            return new LanguageSourceSetNativeDependencySet((HeaderExportingSourceSet)sourceSet);
        }
        return new EmptyNativeDependencySet();
    }

    private static class LanguageSourceSetNativeDependencySet
    extends EmptyNativeDependencySet {
        private final HeaderExportingSourceSet sourceSet;

        private LanguageSourceSetNativeDependencySet(HeaderExportingSourceSet sourceSet) {
            this.sourceSet = sourceSet;
        }

        public FileCollection getIncludeRoots() {
            return new AbstractFileCollection(){

                public String getDisplayName() {
                    return "Include roots of " + LanguageSourceSetNativeDependencySet.this.sourceSet.getName();
                }

                public Set<File> getFiles() {
                    return LanguageSourceSetNativeDependencySet.this.sourceSet.getExportedHeaders().getSrcDirs();
                }

                public TaskDependency getBuildDependencies() {
                    return LanguageSourceSetNativeDependencySet.this.sourceSet.getBuildDependencies();
                }
            };
        }
    }

    private static class EmptyNativeDependencySet
    implements NativeDependencySet {
        private EmptyNativeDependencySet() {
        }

        public FileCollection getIncludeRoots() {
            return this.empty();
        }

        public FileCollection getLinkFiles() {
            return this.empty();
        }

        public FileCollection getRuntimeFiles() {
            return this.empty();
        }

        private FileCollection empty() {
            return new SimpleFileCollection(new File[0]);
        }
    }
}

