/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.internal.resolve;

import org.gradle.api.DomainObjectSet;
import org.gradle.api.Project;
import org.gradle.nativebinaries.NativeBinary;
import org.gradle.nativebinaries.NativeLibrary;
import org.gradle.nativebinaries.NativeLibraryRequirement;
import org.gradle.nativebinaries.internal.resolve.LibraryBinaryLocator;
import org.gradle.nativebinaries.internal.resolve.LibraryResolveException;
import org.gradle.nativebinaries.internal.resolve.ProjectLocator;
import org.gradle.runtime.base.ProjectComponentContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectLibraryBinaryLocator
implements LibraryBinaryLocator {
    private final ProjectLocator projectLocator;

    public ProjectLibraryBinaryLocator(ProjectLocator projectLocator) {
        this.projectLocator = projectLocator;
    }

    @Override
    public DomainObjectSet<NativeBinary> getBinaries(NativeLibraryRequirement requirement) {
        Project project = this.findProject(requirement);
        ProjectComponentContainer projectComponentContainer = (ProjectComponentContainer)project.getExtensions().findByType(ProjectComponentContainer.class);
        if (projectComponentContainer == null) {
            throw new LibraryResolveException(String.format("Project does not have a libraries container: '%s'", project.getPath()));
        }
        return ((NativeLibrary)projectComponentContainer.withType(NativeLibrary.class).getByName(requirement.getLibraryName())).getBinaries();
    }

    private Project findProject(NativeLibraryRequirement requirement) {
        return this.projectLocator.locateProject(requirement.getProjectPath());
    }
}

