/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.internal.resolve;

import java.util.ArrayList;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.dsl.dependencies.ProjectFinder;
import org.gradle.nativebinaries.internal.prebuilt.PrebuiltLibraryBinaryLocator;
import org.gradle.nativebinaries.internal.resolve.ApiRequirementNativeDependencyResolver;
import org.gradle.nativebinaries.internal.resolve.ChainedLibraryBinaryLocator;
import org.gradle.nativebinaries.internal.resolve.DefaultProjectLocator;
import org.gradle.nativebinaries.internal.resolve.InputHandlingNativeDependencyResolver;
import org.gradle.nativebinaries.internal.resolve.LibraryBinaryLocator;
import org.gradle.nativebinaries.internal.resolve.LibraryNativeDependencyResolver;
import org.gradle.nativebinaries.internal.resolve.NativeDependencyResolver;
import org.gradle.nativebinaries.internal.resolve.ProjectLibraryBinaryLocator;
import org.gradle.nativebinaries.internal.resolve.ProjectLocator;
import org.gradle.nativebinaries.internal.resolve.RequirementParsingNativeDependencyResolver;
import org.gradle.nativebinaries.internal.resolve.SourceSetNativeDependencyResolver;

public class NativeDependencyResolverServices {
    public ProjectLocator createProjectLocator(ProjectFinder projectFinder, DependencyMetaDataProvider metaDataProvider) {
        String currentProjectPath = metaDataProvider.getModule().getProjectPath();
        return new DefaultProjectLocator(currentProjectPath, projectFinder);
    }

    public LibraryBinaryLocator createLibraryBinaryLocator(ProjectLocator projectLocator) {
        ArrayList<LibraryBinaryLocator> locators = new ArrayList<LibraryBinaryLocator>();
        locators.add(new ProjectLibraryBinaryLocator(projectLocator));
        locators.add(new PrebuiltLibraryBinaryLocator(projectLocator));
        return new ChainedLibraryBinaryLocator(locators);
    }

    public NativeDependencyResolver createResolver(LibraryBinaryLocator locator) {
        NativeDependencyResolver resolver = new LibraryNativeDependencyResolver(locator);
        resolver = new ApiRequirementNativeDependencyResolver(resolver);
        resolver = new RequirementParsingNativeDependencyResolver(resolver);
        resolver = new SourceSetNativeDependencyResolver(resolver);
        return new InputHandlingNativeDependencyResolver(resolver);
    }
}

