/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.internal.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.api.specs.Spec;
import org.gradle.nativebinaries.NativeDependencySet;
import org.gradle.nativebinaries.NativeLibraryBinary;
import org.gradle.nativebinaries.ProjectNativeBinary;
import org.gradle.nativebinaries.internal.resolve.NativeBinaryRequirementResolveResult;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeBinaryResolveResult {
    private final ProjectNativeBinary target;
    private final List<NativeBinaryRequirementResolveResult> resolutions = new ArrayList<NativeBinaryRequirementResolveResult>();

    public NativeBinaryResolveResult(ProjectNativeBinary target, Collection<?> libs) {
        this.target = target;
        for (Object lib : libs) {
            this.resolutions.add(new NativeBinaryRequirementResolveResult(lib));
        }
    }

    public ProjectNativeBinary getTarget() {
        return this.target;
    }

    public List<NativeBinaryRequirementResolveResult> getAllResolutions() {
        return this.resolutions;
    }

    public List<NativeDependencySet> getAllResults() {
        return CollectionUtils.collect(this.getAllResolutions(), (Transformer)new Transformer<NativeDependencySet, NativeBinaryRequirementResolveResult>(){

            public NativeDependencySet transform(NativeBinaryRequirementResolveResult original) {
                return original.getNativeDependencySet();
            }
        });
    }

    public List<NativeLibraryBinary> getAllLibraryBinaries() {
        ArrayList<NativeLibraryBinary> result = new ArrayList<NativeLibraryBinary>();
        for (NativeBinaryRequirementResolveResult resolution : this.getAllResolutions()) {
            if (resolution.getLibraryBinary() == null) continue;
            result.add(resolution.getLibraryBinary());
        }
        return result;
    }

    public List<NativeBinaryRequirementResolveResult> getPendingResolutions() {
        return CollectionUtils.filter(this.resolutions, (Spec)new Spec<NativeBinaryRequirementResolveResult>(){

            public boolean isSatisfiedBy(NativeBinaryRequirementResolveResult element) {
                return !element.isComplete();
            }
        });
    }
}

