/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.internal.resolve;

import java.util.Set;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.InvalidUserDataException;
import org.gradle.nativebinaries.BuildType;
import org.gradle.nativebinaries.Flavor;
import org.gradle.nativebinaries.NativeBinary;
import org.gradle.nativebinaries.NativeDependencySet;
import org.gradle.nativebinaries.NativeLibraryBinary;
import org.gradle.nativebinaries.NativeLibraryRequirement;
import org.gradle.nativebinaries.SharedLibraryBinary;
import org.gradle.nativebinaries.StaticLibraryBinary;
import org.gradle.nativebinaries.internal.NativeLibraryBinaryInternal;
import org.gradle.nativebinaries.internal.resolve.DefaultNativeDependencySet;
import org.gradle.nativebinaries.internal.resolve.LibraryBinaryLocator;
import org.gradle.nativebinaries.internal.resolve.LibraryResolveException;
import org.gradle.nativebinaries.platform.Platform;
import org.gradle.util.GUtil;

class DefaultLibraryResolver {
    private final NativeLibraryRequirement requirement;
    private final NativeBinary context;
    private final LibraryBinaryLocator libraryBinaryLocator;

    public DefaultLibraryResolver(LibraryBinaryLocator libraryBinaryLocator, NativeLibraryRequirement requirement, NativeBinary context) {
        this.requirement = requirement;
        this.context = context;
        this.libraryBinaryLocator = libraryBinaryLocator;
    }

    public NativeLibraryBinaryInternal resolveLibraryBinary() {
        return new LibraryResolution().withFlavor(this.context.getFlavor()).withPlatform(this.context.getTargetPlatform()).withBuildType(this.context.getBuildType()).resolveLibrary(this.libraryBinaryLocator.getBinaries(this.requirement));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LibraryResolution {
        private Flavor flavor;
        private Platform platform;
        private BuildType buildType;

        private LibraryResolution() {
        }

        public LibraryResolution withFlavor(Flavor flavor) {
            this.flavor = flavor;
            return this;
        }

        public LibraryResolution withPlatform(Platform platform) {
            this.platform = platform;
            return this;
        }

        public LibraryResolution withBuildType(BuildType buildType) {
            this.buildType = buildType;
            return this;
        }

        public NativeDependencySet resolve(DomainObjectSet<NativeBinary> allBinaries) {
            NativeLibraryBinaryInternal resolve = this.resolveLibrary(allBinaries);
            return new DefaultNativeDependencySet(resolve);
        }

        public NativeLibraryBinaryInternal resolveLibrary(DomainObjectSet<NativeBinary> allBinaries) {
            Class<? extends NativeLibraryBinary> type = this.getTypeForLinkage(DefaultLibraryResolver.this.requirement.getLinkage());
            DomainObjectSet candidateBinaries = allBinaries.withType(type);
            return this.resolve((Set<? extends NativeLibraryBinary>)candidateBinaries);
        }

        private Class<? extends NativeLibraryBinary> getTypeForLinkage(String linkage) {
            if ("static".equals(linkage)) {
                return StaticLibraryBinary.class;
            }
            if ("shared".equals(linkage) || linkage == null) {
                return SharedLibraryBinary.class;
            }
            throw new InvalidUserDataException("Not a valid linkage: " + linkage);
        }

        private NativeLibraryBinaryInternal resolve(Set<? extends NativeLibraryBinary> candidates) {
            for (NativeLibraryBinary nativeLibraryBinary : candidates) {
                if (this.flavor != null && !this.flavor.getName().equals(nativeLibraryBinary.getFlavor().getName()) || this.platform != null && !this.platform.getName().equals(nativeLibraryBinary.getTargetPlatform().getName()) || this.buildType != null && !this.buildType.getName().equals(nativeLibraryBinary.getBuildType().getName())) continue;
                return (NativeLibraryBinaryInternal)nativeLibraryBinary;
            }
            String typeName = (String)GUtil.elvis((Object)DefaultLibraryResolver.this.requirement.getLinkage(), (Object)"shared");
            throw new LibraryResolveException(String.format("No %s library binary available for library '%s' with [flavor: '%s', platform: '%s', buildType: '%s']", typeName, DefaultLibraryResolver.this.requirement.getLibraryName(), this.flavor.getName(), this.platform.getName(), this.buildType.getName()));
        }
    }
}

