/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.internal.resolve;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.DomainObjectSet;
import org.gradle.nativebinaries.NativeBinary;
import org.gradle.nativebinaries.NativeLibraryRequirement;
import org.gradle.nativebinaries.internal.resolve.LibraryBinaryLocator;
import org.gradle.nativebinaries.internal.resolve.LibraryResolveException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainedLibraryBinaryLocator
implements LibraryBinaryLocator {
    private final List<LibraryBinaryLocator> locators = new ArrayList<LibraryBinaryLocator>();

    public ChainedLibraryBinaryLocator(List<? extends LibraryBinaryLocator> locators) {
        this.locators.addAll(locators);
    }

    @Override
    public DomainObjectSet<NativeBinary> getBinaries(NativeLibraryRequirement requirement) {
        ArrayList<Exception> failures = new ArrayList<Exception>();
        for (LibraryBinaryLocator locator : this.locators) {
            try {
                return locator.getBinaries(requirement);
            }
            catch (Exception e) {
                failures.add(e);
            }
        }
        throw new LibraryResolveException(this.getFailureMessage(requirement), failures);
    }

    private String getFailureMessage(NativeLibraryRequirement requirement) {
        return requirement.getProjectPath() == null ? String.format("Could not locate library '%s'.", requirement.getLibraryName()) : String.format("Could not locate library '%s' for project '%s'.", requirement.getLibraryName(), requirement.getProjectPath());
    }
}

