/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.internal.resolve;

import java.io.File;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.collections.SimpleFileCollection;
import org.gradle.nativebinaries.NativeDependencySet;
import org.gradle.nativebinaries.NativeLibraryRequirement;
import org.gradle.nativebinaries.internal.resolve.NativeBinaryRequirementResolveResult;
import org.gradle.nativebinaries.internal.resolve.NativeBinaryResolveResult;
import org.gradle.nativebinaries.internal.resolve.NativeDependencyResolver;

public class ApiRequirementNativeDependencyResolver
implements NativeDependencyResolver {
    private final NativeDependencyResolver delegate;

    public ApiRequirementNativeDependencyResolver(NativeDependencyResolver delegate) {
        this.delegate = delegate;
    }

    public void resolve(NativeBinaryResolveResult nativeBinaryResolveResult) {
        for (NativeBinaryRequirementResolveResult resolution : nativeBinaryResolveResult.getAllResolutions()) {
            String linkage = this.getLinkage(resolution);
            if (!"api".equals(linkage)) continue;
            resolution.setRequirement(new ApiAdaptedNativeLibraryRequirement(resolution.getRequirement()));
        }
        this.delegate.resolve(nativeBinaryResolveResult);
        for (NativeBinaryRequirementResolveResult resolution : nativeBinaryResolveResult.getAllResolutions()) {
            if (!(resolution.getRequirement() instanceof ApiAdaptedNativeLibraryRequirement)) continue;
            ApiAdaptedNativeLibraryRequirement adaptedRequirement = (ApiAdaptedNativeLibraryRequirement)resolution.getRequirement();
            resolution.setRequirement(adaptedRequirement.getOriginal());
            resolution.setNativeDependencySet(new ApiNativeDependencySet(resolution.getNativeDependencySet()));
        }
    }

    private String getLinkage(NativeBinaryRequirementResolveResult resolution) {
        if (resolution.getRequirement() == null) {
            return null;
        }
        return resolution.getRequirement().getLinkage();
    }

    private static class ApiNativeDependencySet
    implements NativeDependencySet {
        private final NativeDependencySet delegate;

        public ApiNativeDependencySet(NativeDependencySet delegate) {
            this.delegate = delegate;
        }

        public FileCollection getIncludeRoots() {
            return this.delegate.getIncludeRoots();
        }

        public FileCollection getLinkFiles() {
            return new SimpleFileCollection(new File[0]);
        }

        public FileCollection getRuntimeFiles() {
            return new SimpleFileCollection(new File[0]);
        }
    }

    private static class ApiAdaptedNativeLibraryRequirement
    implements NativeLibraryRequirement {
        private final NativeLibraryRequirement original;

        public ApiAdaptedNativeLibraryRequirement(NativeLibraryRequirement original) {
            this.original = original;
        }

        public NativeLibraryRequirement getOriginal() {
            return this.original;
        }

        public String getProjectPath() {
            return this.original.getProjectPath();
        }

        public String getLibraryName() {
            return this.original.getLibraryName();
        }

        public String getLinkage() {
            return null;
        }
    }
}

