/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.internal.prebuilt;

import java.util.ArrayList;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.nativebinaries.NativeBinary;
import org.gradle.nativebinaries.NativeLibraryRequirement;
import org.gradle.nativebinaries.PrebuiltLibraries;
import org.gradle.nativebinaries.PrebuiltLibrary;
import org.gradle.nativebinaries.Repositories;
import org.gradle.nativebinaries.internal.prebuilt.PrebuiltLibraryResolveException;
import org.gradle.nativebinaries.internal.resolve.LibraryBinaryLocator;
import org.gradle.nativebinaries.internal.resolve.ProjectLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrebuiltLibraryBinaryLocator
implements LibraryBinaryLocator {
    private final ProjectLocator projectLocator;

    public PrebuiltLibraryBinaryLocator(ProjectLocator projectLocator) {
        this.projectLocator = projectLocator;
    }

    @Override
    public DomainObjectSet<NativeBinary> getBinaries(NativeLibraryRequirement requirement) {
        ProjectInternal project = this.projectLocator.locateProject(requirement.getProjectPath());
        NamedDomainObjectSet repositories = ((Repositories)project.getModelRegistry().get("repositories", Repositories.class)).withType(PrebuiltLibraries.class);
        if (repositories.isEmpty()) {
            throw new PrebuiltLibraryResolveException("Project does not have any prebuilt library repositories.");
        }
        PrebuiltLibrary prebuiltLibrary = this.getPrebuiltLibrary((NamedDomainObjectSet<PrebuiltLibraries>)repositories, requirement.getLibraryName());
        return prebuiltLibrary.getBinaries();
    }

    private PrebuiltLibrary getPrebuiltLibrary(NamedDomainObjectSet<PrebuiltLibraries> repositories, String libraryName) {
        ArrayList<String> repositoryNames = new ArrayList<String>();
        for (PrebuiltLibraries prebuiltLibraries : repositories) {
            repositoryNames.add(prebuiltLibraries.getName());
            PrebuiltLibrary prebuiltLibrary = prebuiltLibraries.resolveLibrary(libraryName);
            if (prebuiltLibrary == null) continue;
            return prebuiltLibrary;
        }
        throw new PrebuiltLibraryResolveException(String.format("Prebuilt library with name '%s' not found in repositories '%s'.", libraryName, repositoryNames));
    }
}

