/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.internal.configure;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.nativebinaries.BuildType;
import org.gradle.nativebinaries.Flavor;
import org.gradle.nativebinaries.ProjectNativeComponent;
import org.gradle.nativebinaries.internal.TargetedNativeComponentInternal;
import org.gradle.nativebinaries.internal.configure.NativeBinariesFactory;
import org.gradle.nativebinaries.platform.Platform;
import org.gradle.nativebinaries.toolchain.ToolChain;
import org.gradle.nativebinaries.toolchain.internal.ToolChainRegistryInternal;
import org.gradle.runtime.base.internal.BinaryNamingSchemeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectNativeComponentInitializer
implements Action<ProjectNativeComponent> {
    private final NativeBinariesFactory factory;
    private final ToolChainRegistryInternal toolChainRegistry;
    private final Set<Platform> allPlatforms = new LinkedHashSet<Platform>();
    private final Set<BuildType> allBuildTypes = new LinkedHashSet<BuildType>();
    private final Set<Flavor> allFlavors = new LinkedHashSet<Flavor>();
    private final BinaryNamingSchemeBuilder namingSchemeBuilder;

    public ProjectNativeComponentInitializer(NativeBinariesFactory factory, BinaryNamingSchemeBuilder namingSchemeBuilder, ToolChainRegistryInternal toolChainRegistry, Collection<? extends Platform> allPlatforms, Collection<? extends BuildType> allBuildTypes, Collection<? extends Flavor> allFlavors) {
        this.factory = factory;
        this.namingSchemeBuilder = namingSchemeBuilder;
        this.toolChainRegistry = toolChainRegistry;
        this.allPlatforms.addAll(allPlatforms);
        this.allBuildTypes.addAll(allBuildTypes);
        this.allFlavors.addAll(allFlavors);
    }

    public void execute(ProjectNativeComponent projectNativeComponent) {
        TargetedNativeComponentInternal targetedComponent = (TargetedNativeComponentInternal)((Object)projectNativeComponent);
        for (Platform platform : targetedComponent.choosePlatforms(this.allPlatforms)) {
            ToolChain toolChain = this.toolChainRegistry.getForPlatform(platform);
            for (BuildType buildType : targetedComponent.chooseBuildTypes(this.allBuildTypes)) {
                for (Flavor flavor : targetedComponent.chooseFlavors(this.allFlavors)) {
                    BinaryNamingSchemeBuilder namingScheme = this.initializeNamingScheme(targetedComponent, projectNativeComponent.getName(), platform, buildType, flavor);
                    this.factory.createNativeBinaries(projectNativeComponent, namingScheme, toolChain, platform, buildType, flavor);
                }
            }
        }
    }

    private BinaryNamingSchemeBuilder initializeNamingScheme(TargetedNativeComponentInternal component, String name, Platform platform, BuildType buildType, Flavor flavor) {
        BinaryNamingSchemeBuilder builder = this.namingSchemeBuilder.withComponentName(name);
        if (this.usePlatformDimension(component)) {
            builder = builder.withVariantDimension(platform.getName());
        }
        if (this.useBuildTypeDimension(component)) {
            builder = builder.withVariantDimension(buildType.getName());
        }
        if (this.useFlavorDimension(component)) {
            builder = builder.withVariantDimension(flavor.getName());
        }
        return builder;
    }

    private boolean usePlatformDimension(TargetedNativeComponentInternal component) {
        return component.choosePlatforms(this.allPlatforms).size() > 1;
    }

    private boolean useBuildTypeDimension(TargetedNativeComponentInternal component) {
        return component.chooseBuildTypes(this.allBuildTypes).size() > 1;
    }

    private boolean useFlavorDimension(TargetedNativeComponentInternal component) {
        return component.chooseFlavors(this.allFlavors).size() > 1;
    }
}

