/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.internal.configure;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.nativebinaries.NativeExecutableBinary;
import org.gradle.nativebinaries.ProjectNativeBinary;
import org.gradle.nativebinaries.SharedLibraryBinary;
import org.gradle.nativebinaries.StaticLibraryBinary;
import org.gradle.nativebinaries.internal.ProjectNativeBinaryInternal;
import org.gradle.nativebinaries.toolchain.internal.ToolChainInternal;
import org.gradle.runtime.base.internal.BinaryNamingScheme;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProjectNativeBinaryInitializer
implements Action<ProjectNativeBinary> {
    private final File binariesOutputDir;

    ProjectNativeBinaryInitializer(Project project) {
        this.binariesOutputDir = new File(project.getBuildDir(), "binaries");
    }

    public void execute(ProjectNativeBinary nativeBinary) {
        ToolChainInternal tc = (ToolChainInternal)nativeBinary.getToolChain();
        BinaryNamingScheme namingScheme = ((ProjectNativeBinaryInternal)nativeBinary).getNamingScheme();
        File binaryOutputDir = new File(this.binariesOutputDir, namingScheme.getOutputDirectoryBase());
        String baseName = nativeBinary.getComponent().getBaseName();
        if (nativeBinary instanceof NativeExecutableBinary) {
            ((NativeExecutableBinary)((Object)nativeBinary)).setExecutableFile(new File(binaryOutputDir, tc.getExecutableName(baseName)));
        } else if (nativeBinary instanceof SharedLibraryBinary) {
            ((SharedLibraryBinary)((Object)nativeBinary)).setSharedLibraryFile(new File(binaryOutputDir, tc.getSharedLibraryName(baseName)));
            ((SharedLibraryBinary)((Object)nativeBinary)).setSharedLibraryLinkFile(new File(binaryOutputDir, tc.getSharedLibraryLinkFileName(baseName)));
        } else if (nativeBinary instanceof StaticLibraryBinary) {
            ((StaticLibraryBinary)((Object)nativeBinary)).setStaticLibraryFile(new File(binaryOutputDir, tc.getStaticLibraryName(baseName)));
        }
    }
}

