/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.internal.configure;

import org.gradle.api.Action;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.nativebinaries.BuildType;
import org.gradle.nativebinaries.Flavor;
import org.gradle.nativebinaries.NativeLibrary;
import org.gradle.nativebinaries.ProjectNativeBinary;
import org.gradle.nativebinaries.ProjectNativeComponent;
import org.gradle.nativebinaries.internal.ProjectNativeExecutableBinary;
import org.gradle.nativebinaries.internal.ProjectSharedLibraryBinary;
import org.gradle.nativebinaries.internal.ProjectStaticLibraryBinary;
import org.gradle.nativebinaries.internal.configure.NativeBinariesFactory;
import org.gradle.nativebinaries.internal.resolve.NativeDependencyResolver;
import org.gradle.nativebinaries.platform.Platform;
import org.gradle.nativebinaries.toolchain.ToolChain;
import org.gradle.runtime.base.internal.BinaryNamingScheme;
import org.gradle.runtime.base.internal.BinaryNamingSchemeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultNativeBinariesFactory
implements NativeBinariesFactory {
    private final Instantiator instantiator;
    private final Action<ProjectNativeBinary> configureAction;
    private final NativeDependencyResolver resolver;

    DefaultNativeBinariesFactory(Instantiator instantiator, Action<ProjectNativeBinary> configureAction, NativeDependencyResolver resolver) {
        this.configureAction = configureAction;
        this.instantiator = instantiator;
        this.resolver = resolver;
    }

    @Override
    public void createNativeBinaries(ProjectNativeComponent component, BinaryNamingSchemeBuilder namingScheme, ToolChain toolChain, Platform platform, BuildType buildType, Flavor flavor) {
        if (component instanceof NativeLibrary) {
            this.createNativeBinary(ProjectSharedLibraryBinary.class, component, namingScheme.withTypeString("SharedLibrary").build(), toolChain, platform, buildType, flavor);
            this.createNativeBinary(ProjectStaticLibraryBinary.class, component, namingScheme.withTypeString("StaticLibrary").build(), toolChain, platform, buildType, flavor);
        } else {
            this.createNativeBinary(ProjectNativeExecutableBinary.class, component, namingScheme.withTypeString("Executable").build(), toolChain, platform, buildType, flavor);
        }
    }

    private void createNativeBinary(Class<? extends ProjectNativeBinary> type, ProjectNativeComponent component, BinaryNamingScheme namingScheme, ToolChain toolChain, Platform platform, BuildType buildType, Flavor flavor) {
        ProjectNativeBinary nativeBinary = (ProjectNativeBinary)this.instantiator.newInstance(type, new Object[]{component, flavor, toolChain, platform, buildType, namingScheme, this.resolver});
        this.setupDefaults(nativeBinary);
        component.getBinaries().add((Object)nativeBinary);
    }

    private void setupDefaults(ProjectNativeBinary nativeBinary) {
        this.configureAction.execute((Object)nativeBinary);
    }
}

