/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.internal.configure;

import java.util.Collection;
import org.gradle.api.Project;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.model.ModelRule;
import org.gradle.nativebinaries.BuildType;
import org.gradle.nativebinaries.BuildTypeContainer;
import org.gradle.nativebinaries.Flavor;
import org.gradle.nativebinaries.FlavorContainer;
import org.gradle.nativebinaries.ProjectNativeComponent;
import org.gradle.nativebinaries.internal.configure.DefaultNativeBinariesFactory;
import org.gradle.nativebinaries.internal.configure.ProjectNativeBinaryInitializer;
import org.gradle.nativebinaries.internal.configure.ProjectNativeComponentInitializer;
import org.gradle.nativebinaries.internal.resolve.NativeDependencyResolver;
import org.gradle.nativebinaries.platform.Platform;
import org.gradle.nativebinaries.platform.PlatformContainer;
import org.gradle.nativebinaries.toolchain.internal.ToolChainRegistryInternal;
import org.gradle.runtime.base.BinaryContainer;
import org.gradle.runtime.base.ProjectComponentContainer;
import org.gradle.runtime.base.internal.BinaryNamingSchemeBuilder;
import org.gradle.runtime.base.internal.DefaultBinaryNamingSchemeBuilder;

public class CreateNativeBinaries
extends ModelRule {
    private final Instantiator instantiator;
    private final ProjectInternal project;
    private final NativeDependencyResolver resolver;

    public CreateNativeBinaries(Instantiator instantiator, ProjectInternal project, NativeDependencyResolver resolver) {
        this.instantiator = instantiator;
        this.project = project;
        this.resolver = resolver;
    }

    public void create(BinaryContainer binaries, ToolChainRegistryInternal toolChains, PlatformContainer platforms, BuildTypeContainer buildTypes, FlavorContainer flavors) {
        this.project.getExtensions().add("platforms", (Object)platforms);
        this.project.getExtensions().add("buildTypes", (Object)buildTypes);
        this.project.getExtensions().add("flavors", (Object)flavors);
        ProjectNativeBinaryInitializer configureBinaryAction = new ProjectNativeBinaryInitializer((Project)this.project);
        DefaultNativeBinariesFactory factory = new DefaultNativeBinariesFactory(this.instantiator, configureBinaryAction, this.resolver);
        DefaultBinaryNamingSchemeBuilder namingSchemeBuilder = new DefaultBinaryNamingSchemeBuilder();
        ProjectNativeComponentInitializer createBinariesAction = new ProjectNativeComponentInitializer(factory, (BinaryNamingSchemeBuilder)namingSchemeBuilder, toolChains, (Collection<? extends Platform>)((Object)platforms), (Collection<? extends BuildType>)((Object)buildTypes), (Collection<? extends Flavor>)((Object)flavors));
        ProjectComponentContainer softwareComponents = (ProjectComponentContainer)this.project.getExtensions().getByType(ProjectComponentContainer.class);
        for (ProjectNativeComponent component : softwareComponents.withType(ProjectNativeComponent.class)) {
            createBinariesAction.execute(component);
            binaries.addAll(component.getBinaries());
        }
    }
}

