/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.internal.configure;

import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.language.HeaderExportingSourceSet;
import org.gradle.language.base.FunctionalSourceSet;
import org.gradle.language.base.ProjectSourceSet;
import org.gradle.language.base.internal.LanguageSourceSetInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigureGeneratedSourceSets
implements Action<ProjectInternal> {
    public void execute(ProjectInternal project) {
        ProjectSourceSet projectSourceSet = (ProjectSourceSet)project.getExtensions().getByType(ProjectSourceSet.class);
        for (FunctionalSourceSet functionalSourceSet : projectSourceSet) {
            for (LanguageSourceSetInternal languageSourceSet : functionalSourceSet.withType(LanguageSourceSetInternal.class)) {
                Task generatorTask = languageSourceSet.getGeneratorTask();
                if (generatorTask == null) continue;
                languageSourceSet.builtBy(new Object[]{generatorTask});
                this.maybeSetSourceDir(languageSourceSet.getSource(), generatorTask, "sourceDir");
                if (!(languageSourceSet instanceof HeaderExportingSourceSet)) continue;
                this.maybeSetSourceDir(((HeaderExportingSourceSet)languageSourceSet).getExportedHeaders(), generatorTask, "headerDir");
            }
        }
    }

    private void maybeSetSourceDir(SourceDirectorySet sourceSet, Task task, String propertyName) {
        Object value = task.property(propertyName);
        if (value != null) {
            sourceSet.srcDir(value);
        }
    }
}

