/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.internal.configure;

import org.gradle.api.Action;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.language.HeaderExportingSourceSet;
import org.gradle.language.base.FunctionalSourceSet;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.ProjectSourceSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplySourceSetConventions
implements Action<ProjectInternal> {
    public void execute(ProjectInternal project) {
        ProjectSourceSet projectSourceSet = (ProjectSourceSet)project.getExtensions().getByType(ProjectSourceSet.class);
        for (FunctionalSourceSet functionalSourceSet : projectSourceSet) {
            for (LanguageSourceSet languageSourceSet : functionalSourceSet) {
                if (!languageSourceSet.getSource().getSrcDirs().isEmpty()) continue;
                languageSourceSet.getSource().srcDir((Object)String.format("src/%s/%s", functionalSourceSet.getName(), languageSourceSet.getName()));
            }
            for (HeaderExportingSourceSet headerSourceSet : functionalSourceSet.withType(HeaderExportingSourceSet.class)) {
                if (headerSourceSet.getExportedHeaders().getSrcDirs().isEmpty()) {
                    headerSourceSet.getExportedHeaders().srcDir((Object)String.format("src/%s/headers", functionalSourceSet.getName()));
                }
                headerSourceSet.getImplicitHeaders().setSrcDirs((Iterable)headerSourceSet.getSource().getSrcDirs());
                headerSourceSet.getImplicitHeaders().include(new String[]{"**/*.h"});
            }
        }
    }
}

